/******************************************************************************/
/* SYSTEM_FILE.C                                                              */
/* ----------------                                                           */
/* MiniFMOD public source code release.                                       */
/* This source is provided as-is.  Firelight Multimedia will not support      */
/* or answer questions about the source provided.                             */
/* MiniFMOD Sourcecode is copyright (c) 2000, Firelight Multimedia.           */
/* MiniFMOD Sourcecode is in no way representative of FMOD 3 source.          */
/* Firelight Multimedia is a registered business name.                        */
/* This source must not be redistributed without this notice.                 */
/******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "minifmod.h"
#include "system_file.h"
#include "system_memory.h"
#include "sound.h"

char * music_data;
int music_len;
int music_pos;

int FSOUND_File_Read(void *buffer, int size)
{
//  *** This is just a check, but it shouldn't happen...
//	if (music_pos + size >= music_len) size = music_len - music_pos;

	memcpy(buffer, (char *)music_data+music_pos, size);
	music_pos += size;
	
	return size;
}

void FSOUND_File_Seek(int pos, signed char mode)
{
	if (mode == SEEK_SET) 		 music_pos = pos;
	else if (mode == SEEK_CUR) music_pos += pos;

//	*** This is never called!
//	else if (mode == SEEK_END) music_pos = music_len + pos;

//	*** Just a check...
//	if (music_pos > music_len) music_pos = music_len;
}

int FSOUND_File_Tell()
{
	return music_pos; 
}
