#ifndef __gpmain_h__
#define __gpmain_h__

enum
{
	NEW_GAME = 0,
	CREDITS,
	INTRO,
	EXIT
};

enum
{
	SIDE = 0,
	COMPUTER,
	USEBOOK,
	VIEW,
	TIME,
	SPEED,
	PLAY,
	CANCEL
};

enum
{
	ABORT_GAME = 0,
	RESUME_GAME,
	CHANGE_VIEW,
	EXIT_GAME
};

enum
{
	selectedColor = 0,
	selectedLevel,
	selectedBook,
	selectedView,
	selectedTime,
	selectedIncrement,
	selectedSpeed
};

typedef struct
{
	int master_speed;
	int div_factor;
	int clk_mode;
} Overclock;

enum
{
	SPEED_40 = 0,
	SPEED_66,
	SPEED_80,
	SPEED_100,
	SPEED_120,
	SPEED_133
};

const Overclock speeds[] = {
	{ 40,0x48013,1},
	{ 66,0x24002,2},
	{ 80,0x48012,2},
	{100,0x2a011,3},
	{120,0x20011,3},
	{132,0x24011,3}
};

const int srates[] = {
	11088,
	12050,
	11088,
	11088,
	11088,
	12050
};

void GpMain(void * arg);
void Init(u8);
void readMove(u8 col);
void gm_flip(void);
void setSpeed(u8);
void animateMove(u8,u8);

GPDRAWSURFACE gpDraw[2];               /* buffers */

#endif /*__gpmain_h__*/
