
local effu_start
local last
local boom = 0

function animator_load()
end

-- done just before first _paint
function animator_init(millis)
	last = 0

	effu_start = millis
end


-- millis = milliseconds in song
function animator_paint(millis, timedelta, params)
	spectrum = engine_spectrum()

	beat = 0
	local beatcount = 50
	for i = 00, 150+beatcount do
		beat = beat + spectrum[i]
	end

	beat = beat / beatcount

	boom = boom + beat*800
	if boom < 0 then boom = 0 end
	
	glClearColor(1.0,1.0,1.0,1);
        glClear(GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT)

	if params.delta then
                millis = time + params.delta
        end

	glPushMatrix()
	glEnable(GL_MULTISAMPLE)
		glLoadIdentity()
		glOrtho(0, 1, 0, 1, -100, 100)
		glMatrixMode(GL_MODELVIEW)

		glEnable(GL_BLEND)
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)

		glEnable(GL_TEXTURE_2D)

		-- draw canvas

		glBindTexture(GL_TEXTURE_2D, canvas_texid)
		glPushMatrix()
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
		glColor4d(1,1,1,0.7)

		size = height
		glBegin(GL_QUADS)
			glTexCoord2d(0,0)
			glVertex3d(0,0,-3)
			glTexCoord2d(1,0)
			glVertex3d(1,0,-3)
			glTexCoord2d(1,1)
			glVertex3d(1,1,-3)
			glTexCoord2d(0,1)
			glVertex3d(0,1,-3)
		glEnd()

		glPopMatrix()

		-- draw current scene background

		if params.bg then
			bg = params.bg
		else
			bg = 0
		end

		if bg == "savannahbg" then
			glBindTexture(GL_TEXTURE_2D, savannahbg_texid)
		end

		if bg == "ponybg" then
			glBindTexture(GL_TEXTURE_2D, ponybg_texid)
		end

        if bg == "desertbg" then
			glBindTexture(GL_TEXTURE_2D, desertbg_texid)
		end

		if bg == "bunnybg" then
			glBindTexture(GL_TEXTURE_2D, bunnybg_texid)
		end

        if bg == "rainbowbg" then
			glBindTexture(GL_TEXTURE_2D, rainbowbg_texid)
		end

		if bg == "redbg" then
			glBindTexture(GL_TEXTURE_2D, redbg_texid)
		end

		if bg == "scenemissing" then
			glBindTexture(GL_TEXTURE_2D, scenemissing_texid)
		end

		glPushMatrix()
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
		glColor4d(1,1,1,1)

		size = height
		glBegin(GL_QUADS)
			glTexCoord2d(0,0)
			glVertex3d(0,0,-2)
			glTexCoord2d(1,0)
			glVertex3d(1,0,-2)
			glTexCoord2d(1,1)
			glVertex3d(1,1,-2)
			glTexCoord2d(0,1)
			glVertex3d(0,1,-2)
		glEnd()

		glPopMatrix()

		-- parse current actors and render accordingly
	
		positions = {0, 0.2, 0.4, 0.6, 0.8}

		glPushMatrix()

		glEnable(GL_BLEND);
		if params.actors then
			for i = 0, 50 do
				if params.actors[i] then

					xpos = 0
					ypos = 0
					xmod = 0
					ymod = 0
					size = 0
					xsize = 0
					ysize = 0
					rot = 0
                    sink = 0

					-- actor type (corresponds to sprite name)
					if params.actors[i].type then
						if params.actors[i].type == "char" then
							glBindTexture(GL_TEXTURE_2D, _G[params.actors[i].name .. "_texid"])
						elseif params.actors[i].type == "sprite" then
							glBindTexture(GL_TEXTURE_2D, _G[params.actors[i].name .. "_texid"])
						end
					else
						print("actor type missing for actor #" .. i .. " in scene #" .. scene)
					end

					-- actor pos (horizontal position, 5 fixed positions)
					if params.actors[i].actor_pos then
						xpos = positions[params.actors[i].actor_pos]
						ypos = 0
					end

					-- absolute xpos
					if params.actors[i].xpos then
						xpos = params.actors[i].xpos
					end

					-- absolute ypos
					if params.actors[i].ypos then
						ypos = params.actors[i].ypos
					end

					-- size
					if params.actors[i].size then
						xsize = params.actors[i].size
						ysize = params.actors[i].size
					else
						if params.actors[i].xsize then
							xsize = params.actors[i].xsize
						else
							xsize = 1.0
						end

						if params.actors[i].ysize then
							ysize = params.actors[i].ysize
						else
							ysize = 1.0
						end
					end

					if params.actors[i].xmod then
						xmod = params.actors[i].xmod
					end

					if params.actors[i].ymod then
						ymod = params.actors[i].ymod
					end

					-- actor action (trigger animation or play event)
					if params.actors[i].action then
						if params.actors[i].action == "hop" then
							ymod = math.abs(math.cos(millis*0.008+i)*0.1)
						elseif params.actors[i].action == "spin" then
							ymod = ymod + math.abs(math.cos(millis*0.008+i)*0.1)
							rot = (math.cos(millis*0.0008+i)*360)
						elseif params.actors[i].action == "hopwalkleft" then
                            if not params.actors[i].hopwalk_start_millis then
                                params.actors[i].hopwalk_start_millis = millis
                            end
							ymod = ymod + math.abs(math.cos(millis*0.008+i)*0.1)
                            xmod = xmod -(millis-params.actors[i].hopwalk_start_millis)*0.0001
						elseif params.actors[i].action == "hopwalkright" then
                            if not params.actors[i].hopwalk_start_millis then
                                params.actors[i].hopwalk_start_millis = millis
                            end
							ymod = ymod + math.abs(math.cos(millis*0.008+i)*0.1)
                            xmod = xmod + (millis-params.actors[i].hopwalk_start_millis)*0.0001
						elseif params.actors[i].action == "seesaw" then
							rot = (math.cos(millis*0.008+i)*2)
                        elseif params.actors[i].action == "sink" then
                            if not params.actors[i].sink_start_millis then
                                params.actors[i].sink_start_millis = millis
                            end
                            ymod = ymod - (millis-params.actors[i].sink_start_millis)*0.0001
                            sink = (millis-params.actors[i].sink_start_millis)*0.0005
						end
					end


					glPushMatrix()
						glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
						glColor4d(1,1,1,1)

						glTranslated(xsize/2,ysize/2, 0)
						glTranslated(xpos+xmod,ypos+ymod,0)
						glRotated(rot,0,0,1)
						glTranslated(-xsize/2,-ysize/2, 0)


						if params.actors[i].dir then
							if params.actors[i].dir == "l" then
								glBegin(GL_QUADS)
									glTexCoord2d(1,0+sink)
									glVertex3d(0,0,-1+i*0.01)
									glTexCoord2d(0,0+sink)
									glVertex3d(xsize,0,-1+i*0.01)
									glTexCoord2d(0,1+sink)
									glVertex3d(xsize,ysize,-1+i*0.01)
									glTexCoord2d(1,1+sink)
									glVertex3d(0,ysize,-1+i*0.01)
								glEnd()
							end
						else
							glBegin(GL_QUADS)
								glTexCoord2d(0,0+sink)
								glVertex3d(0,0,-1+i*0.01)
								glTexCoord2d(1,0+sink)
								glVertex3d(xsize,0,-1+i*0.01)
								glTexCoord2d(1,1+sink)
								glVertex3d(xsize,ysize,-1+i*0.01)
								glTexCoord2d(0,1+sink)
								glVertex3d(0,ysize,-1+i*0.01)
							glEnd()
						end
					glPopMatrix()

				end
			end
		end
		
		glPopMatrix()

		glDisable(GL_TEXTURE_2D)
		glDisable(GL_BLEND)

	glDisable(GL_MULTISAMPLE)
	glPopMatrix()
end
