
; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DU8.asm - Direct3D 8.0 Utils code, VisualC++ 6.0 version.
;   Copyright (c) 2001. Remage / Fresh!mindworkz.
; ---------------------------------------------------------------------------------------------------------------------------------------

; ==================================================
    SECTION .code
; ==================================================

GLOBAL _D3DUMatrixIdentity

GLOBAL _D3DUVec3Create@16
GLOBAL _D3DUVec3Copy@8
GLOBAL _D3DUVec3Add@12
GLOBAL _D3DUVec3Sub@12
GLOBAL _D3DUVec3Scale@12
GLOBAL _D3DUVec3Cross@12
GLOBAL _D3DUVec3Dot@8
GLOBAL _D3DUVec3LengthSq@4
GLOBAL _D3DUVec3Length@4
GLOBAL _D3DUVec3Normalize@8

GLOBAL _D3DUMatrixCopy@8
GLOBAL _D3DUMatrixMultiply@12
GLOBAL _D3DUMatrixTranslation@16
GLOBAL _D3DUMatrixRotationX@8
GLOBAL _D3DUMatrixRotationY@8
GLOBAL _D3DUMatrixRotationZ@8
GLOBAL _D3DUMatrixScaling@16
GLOBAL _D3DUMatrixLookAtLH@16
GLOBAL _D3DUMatrixPerspectiveFovLH@20
GLOBAL _D3DUMatrixOrthoLH@20

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DVECTOR *D3DUVec3Create( D3DVECTOR *pOut, FLOAT x, FLOAT y, FLOAT z )
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Create@16:
    push ebx
    mov eax, dword [esp+8]
    mov ebx, dword [esp+12]
    mov dword [eax+0], ebx
    mov ebx, dword [esp+16]
    mov dword [eax+4], ebx
    mov ebx, dword [esp+20]
    mov dword [eax+8], ebx
    pop ebx
    ret 16

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DVECTOR *D3DUVec3Copy( D3DVECTOR *pOut, const D3DVECTOR *pV );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Copy@8:
    push ebx
    push edx
    mov eax, dword [esp+12]
    mov ebx, dword [esp+16]
    mov edx, dword [ebx+0]
    mov dword [eax+0], edx
    mov edx, dword [ebx+4]
    mov dword [eax+4], edx
    mov edx, dword [ebx+8]
    mov dword [eax+8], edx
    pop edx
    pop ebx
    ret 8

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DVECTOR *D3DUVec3Add( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Add@12:
    push ebx
    push edx
    mov eax, dword [esp+12]
    mov ebx, dword [esp+16]
    mov edx, dword [esp+20]
    fld dword [ebx+0]
    fadd dword [edx+0]
    fld dword [ebx+4]
    fadd dword [edx+4]
    fld dword [ebx+8]
    fadd dword [edx+8]
    fxch st0, st2
    fstp dword [eax+0]
    fstp dword [eax+4]
    fstp dword [eax+8]
    pop edx
    pop ebx
    ret 12

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DVECTOR *D3DUVec3Sub( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Sub@12:
    push ebx
    push edx
    mov eax, dword [esp+12]
    mov ebx, dword [esp+16]
    mov edx, dword [esp+20]
    fld dword [ebx+0]
    fsub dword [edx+0]
    fld dword [ebx+4]
    fsub dword [edx+4]
    fld dword [ebx+8]
    fsub dword [edx+8]
    fxch st0, st2
    fstp dword [eax+0]
    fstp dword [eax+4]
    fstp dword [eax+8]
    pop edx
    pop ebx
    ret 12

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DVECTOR *D3DUVec3Scale( D3DVECTOR *pOut, D3DVECTOR *pV, FLOAT Val );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Scale@12:
  push ebx
  mov eax, dword [esp+8]
  mov ebx, dword [esp+12]
  fld dword [ebx+0]
  fmul dword [esp+16]
  fld dword [ebx+4]
  fmul dword [esp+16]
  fld dword [ebx+8]
  fmul dword [esp+16]
  fxch st0, st2
  fstp dword [eax+0]
  fstp dword [eax+4]
  fstp dword [eax+8]
  pop ebx
  ret 12

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DVECTOR *D3DUVec3Cross( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Cross@12:
    push ebx
    push edx
    mov eax, dword [esp+12]
    mov ebx, dword [esp+16]
    mov edx, dword [esp+20]
    fld dword [edx+8]
    fld dword [edx+4]
    fld dword [edx+0]
    fld dword [ebx+4]
    fld dword [ebx+0]
    fld dword [ebx+8]
    fld st0
    fmul st0, st4
    fxch st0, st5
    fmul st1, st0
    fmul st0, st2
    fxch st0, st6
    fmul st2, st0
    fmul st0, st3
    fxch st0, st4
    fmulp st3, st0
    fsubp st3, st0
    fsubp st3, st0
    fsubp st3, st0
    fstp dword [eax+0]
    fstp dword [eax+4]
    fstp dword [eax+8]
    pop edx
    pop ebx
    ret 12

; ---------------------------------------------------------------------------------------------------------------------------------------
;   FLOAT D3DUVec3Dot( D3DVECTOR *pV1, D3DVECTOR *pV2 );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Dot@8:
    push ebx
    push edx

    mov ebx, dword [esp+12]
    mov edx, dword [esp+16]
    fld dword [ebx+0]
    fmul dword [edx+0]
    fld dword [ebx+4]
    fmul dword [edx+4]
    fld dword [ebx+8]
    fmul dword [edx+8]
    fxch st0, st2
    faddp st1, st0
    faddp st1, st0

    pop edx
    pop ebx
    ret 8

; ---------------------------------------------------------------------------------------------------------------------------------------
;   FLOAT D3DUVec3LengthSq( D3DVECTOR *pV );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3LengthSq@4:
    push ebx
    mov ebx, dword [esp+8]

    fld dword [ebx+0]
    fmul st0, st0
    fld dword [ebx+4]
    fmul st0, st0
    fld dword [ebx+8]
    fmul st0, st0
    fxch st0, st2
    faddp st1, st0
    faddp st1, st0

    pop ebx
    ret 4
    
; ---------------------------------------------------------------------------------------------------------------------------------------
;   FLOAT D3DUVec3Length( D3DVECTOR *pV );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Length@4:
    push ebx
    mov ebx, dword [esp+8]
    fld dword [ebx+0]
    fmul st0, st0
    fld dword [ebx+4]
    fmul st0, st0
    fld dword [ebx+8]
    fmul st0, st0
    fxch st0, st2
    faddp st1, st0
    faddp st1, st0
    fsqrt
    pop ebx
    ret 4
    
; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DVECTOR *D3DUVec3Normalize( D3DVECTOR *pOut, D3DVECTOR *pV );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUVec3Normalize@8:
    push ebx
    mov eax, dword [esp+8]

    mov ebx, dword [esp+12]
    fld1
    fld dword [ebx+0]
    fmul st0, st0
    fld dword [ebx+4]
    fmul st0, st0
    fld dword [ebx+8]
    fmul st0, st0
    fxch st0, st2
    faddp st1, st0
    faddp st1, st0
    fsqrt
    fdivp st1, st0

    fld dword [ebx+0]
    fmul st0, st1
    fld dword [ebx+4]
    fmul st0, st2
    fld dword [ebx+8]
    fmulp st3, st0
    fstp dword [eax+4]
    fstp dword [eax+0]
    fstp dword [eax+8]

    pop ebx
    ret 8

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DUMatrixCopy( D3DMATRIX *pOut, D3DMATRIX *pM );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUMatrixCopy@8:
    push esi
    mov eax, dword [esp+8]
    mov esi, dword [esp+12]
    push edi
    push ecx
    mov edi, eax
    mov ecx, 16
    rep movsd    
    pop ecx
    pop edi
    pop esi
    ret 8

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DUMatrixMultiply( D3DMATRIX *pOut, D3DMATRIX *pM1, D3DMATRIX *pM2 );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUMatrixMultiply@12:
    push ebx
    push ecx
    push edx
    mov eax, dword [esp+16]
    mov ebx, dword [esp+20]
    mov edx, dword [esp+24]
    
    xor ecx, ecx
.Loop1:

    fld dword [ebx+ecx+0]       ; m1_i0
    fld dword [ebx+ecx+16]      ; m1_i1, m1_i0
    fld dword [ebx+ecx+32]      ; m1_i2, m1_i1, m1_i0
    fld dword [ebx+ecx+48]      ; m1_i3, m1_i2, m1_i1, m1_i0

    fld dword [edx+0]               ; pM2->_11, m1_i3, m1_i2, m1_i1, m1_i0
    fmul st0, st4
    fld dword [edx+16]               
    fmul st0, st4
    fld dword [edx+32]               
    fmul st0, st4
    fld dword [edx+48]               
    fmul st0, st4
    fxch st0, st3
    faddp st1, st0
    faddp st1, st0
    faddp st1, st0
    fstp dword [eax+ecx+0]

    fld dword [edx+4]
    fmul st0, st4
    fld dword [edx+20]               
    fmul st0, st4
    fld dword [edx+36]               
    fmul st0, st4
    fld dword [edx+52]               
    fmul st0, st4
    fxch st0, st3
    faddp st1, st0
    faddp st1, st0
    faddp st1, st0
    fstp dword [eax+ecx+16]

    fld dword [edx+8]
    fmul st0, st4
    fld dword [edx+24]               
    fmul st0, st4
    fld dword [edx+40]               
    fmul st0, st4
    fld dword [edx+56]               
    fmul st0, st4
    fxch st0, st3
    faddp st1, st0
    faddp st1, st0
    faddp st1, st0
    fstp dword [eax+ecx+32]

    fld dword [edx+12]
    fmul st0, st4
    fld dword [edx+28]               
    fmul st0, st4
    fld dword [edx+44]               
    fmul st0, st4
    fld dword [edx+60]               
    fmul st0, st4
    fxch st0, st3
    faddp st1, st0
    faddp st1, st0
    faddp st1, st0
    fstp dword [eax+ecx+48]

    fstp st0
    fstp st0
    fstp st0
    fstp st0

    add ecx, 4
    cmp ecx, 16
    jnz .Loop1

    pop edx
    pop ecx
    pop ebx
    ret 12

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DMATRIX *D3DUMatrixTranslation( D3DMATRIX *pOut, FLOAT x, FLOAT y, FLOAT z )
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUMatrixTranslation@16:
    push esi
    mov eax, dword [esp+8]

    mov esi, _D3DUMatrixIdentity
    push edi
    mov edi, eax
    push ecx
    mov ecx, 16
    rep movsd
    pop ecx
    pop edi

    mov esi, dword [esp+12]
    mov dword [eax+48], esi
    mov esi, dword [esp+16]
    mov dword [eax+52], esi
    mov esi, dword [esp+20]
    mov dword [eax+56], esi

    pop esi
    ret 16

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DMATRIX *D3DUMatrixRotationX( D3DMATRIX *pOut, FLOAT Angle )
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUMatrixRotationX@8:
    push esi
    mov eax, dword [esp+8]

    mov esi, _D3DUMatrixIdentity
    push edi
    mov edi, eax
    push ecx
    mov ecx, 16
    rep movsd
    pop ecx
    pop edi

    fld dword [esp+12]
    fsincos
    fst dword [eax+20]
    fstp dword [eax+40]
    fst dword [eax+24]
    fchs
    fstp dword [eax+36]

    pop esi
    ret 8

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DMATRIX *D3DUMatrixRotationY( D3DMATRIX *pOut, FLOAT Angle );
; ---------------------------------------------------------------------------------------------------------------------------------------
;   pOut->_11 = fcos( Angle ); pOut->_13 = -fsin( Angle );
;   pOut->_31 = fsin( Angle ); pOut->_33 = fcos( Angle );  

_D3DUMatrixRotationY@8:
    push esi
    mov eax, dword [esp+8]

    mov esi, _D3DUMatrixIdentity
    push edi
    mov edi, eax
    push ecx
    mov ecx, 16
    rep movsd
    pop ecx
    pop edi

    fld dword [esp+12]
    fsincos
    fst dword [eax]
    fstp dword [eax+40]
    fst dword [eax+32]
    fchs
    fstp dword [eax+8]

    pop esi
    ret 8

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DMATRIX* D3DUMatrixRotationZ( D3DMATRIX *pOut, FLOAT Angle );
; ---------------------------------------------------------------------------------------------------------------------------------------
;   pOut->_11 = fcos( Angle ); pOut->_12 = fsin( Angle );
;   pOut->_21 = -fsin( Angle ); pOut->_22 = fcos( Angle );

_D3DUMatrixRotationZ@8:
    push esi
    mov eax, dword [esp+8]

    mov esi, _D3DUMatrixIdentity
    push edi
    mov edi, eax
    push ecx
    mov ecx, 16
    rep movsd
    pop ecx
    pop edi

    fld dword [esp+12]
    fsincos
    fst dword [eax]
    fstp dword [eax+20]
    fst dword [eax+4]
    fchs
    fstp dword [eax+16]

    pop esi
    ret 8

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DMATRIX* D3DUMatrixScaling( D3DMATRIX *pOut, FLOAT sx, FLOAT sy, FLOAT sz );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUMatrixScaling@16:
    push esi
    mov eax, dword [esp+8]

    mov esi, _D3DUMatrixIdentity
    push edi
    mov edi, eax
    push ecx
    mov ecx, 16
    rep movsd
    pop ecx
    pop edi

    mov esi, dword [esp+12]
    mov dword [eax], esi
    mov esi, dword [esp+16]
    mov dword [eax+20], esi
    mov esi, dword [esp+20]
    mov dword [eax+40], esi

    pop esi
    ret 16

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DMATRIX *D3DUMatrixLookAtLH( D3DMATRIX *pOut, D3DVECTOR *pEye, D3DVECTOR *pAt, D3DVECTOR *pUp )
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUMatrixLookAtLH@16:
    push esi
    ; mov eax, dword [esp+8]
                                                ; STACK: esi [ret] pOut pEye pAt pUp 
    push dword [esp+12]             ; pEye esi [ret] pOut pEye pAt pUp 
    push dword [esp+20]             ; pAt pEye esi [ret] pOut pEye pAt pUp   
    push dword _D3DUVec3Z        ; &Z pAt pEye esi [ret] pOut pEye pAt pUp 
    call _D3DUVec3Sub@12          ; esi [ret] pOut pEye pAt pUp 
    
    push dword [esp+12]              ; pEye esi [ret] pOut pEye pAt pUp 
    call _D3DUVec3LengthSq@4    ; esi [ret] pOut pEye pAt pUp 

    ; FPUStack: Len

    push dword _D3DUVec3Z                         
    push dword _D3DUVec3Z                         
    call _D3DUVec3Normalize@8

    push dword [esp+20]
    push dword _D3DUVec3Y
    call _D3DUVec3Normalize@8

    push dword _D3DUVec3Z
    push dword _D3DUVec3Y
    push dword _D3DUVec3X
    call _D3DUVec3Cross@12

    push dword _D3DUVec3X
    push dword _D3DUVec3Z
    push dword _D3DUVec3Y
    call _D3DUVec3Cross@12

    push dword _D3DUVec3X
    push dword _D3DUVec3X
    call _D3DUVec3Normalize@8

    push dword _D3DUVec3Y
    push dword _D3DUVec3Y
    call _D3DUVec3Normalize@8

    ; esi [ret] pOut pEye pAt pUp 

    push dword [esp+16]
    push dword _D3DUVec3X
    call _D3DUVec3Dot@8
    fchs
    fst dword [_D3DUMatrixLookAt+48]
    fmul st0, st0
    fsubp st1, st0

    ; FPU Stack: Len - Fsqr(pOut->41)

    push dword [esp+16]
    push dword _D3DUVec3Y
    call _D3DUVec3Dot@8
    fchs
    fst dword [_D3DUMatrixLookAt+52]
    fmul st0, st0
    fsubp st1, st0

    ; FPU Stack: Len - Fsqr(pOut->41) - Fsqr(pOut->42)

    fsqrt
    fstp dword [_D3DUMatrixLookAt+56]

    mov eax, dword [esp+8]
    mov esi, dword _D3DUMatrixLookAt
    push edi
    mov edi, eax
    push ecx
    mov ecx, 16
    rep movsd
    pop ecx
    pop edi

    pop esi
    ret 16

;   D3DUMatrixCopy( pOut, &D3DUMatrixIdentity );
;   D3DUVec3Sub( &Z, pAt, pEye );
;   Len = D3DUVec3LengthSq( pEye );
;   D3DUVec3Normalize( &Z, &Z );
;   D3DUVec3Normalize( &Y, pUp );
;   D3DUVec3Cross( &X, &Y, &Z );
;   D3DUVec3Cross( &Y, &Z, &X );
;   D3DUVec3Normalize( &X, &X );
;   D3DUVec3Normalize( &Y, &Y );
;   pOut->_11 = X.x; pOut->_21 = X.y; pOut->_31 = X.z;
;   pOut->_12 = Y.x; pOut->_22 = Y.y; pOut->_32 = Y.z;
;   pOut->_13 = Z.x; pOut->_23 = Z.y; pOut->_33 = Z.z;
;   pOut->_41 = -D3DUVec3Dot( &X, pAt );
;   pOut->_42 = -D3DUVec3Dot( &Y, pAt );
;   pOut->_43 = (FLOAT) fsqrt( Len - pOut->_41 * pOut->_41 - pOut->_42 * pOut->_42 );

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DMATRIX* D3DUMatrixPerspectiveFovLH( D3DMATRIX* pOut, FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUMatrixPerspectiveFovLH@20:
    push esi
    mov eax, dword [esp+8]

    mov esi, _D3DUMatrixIdentity
    push edi
    mov edi, eax
    push ecx
    mov ecx, 16
    rep movsd
    pop ecx
    pop edi

    fld dword [esp+24]
    fsub dword [esp+20]
    fld dword [esp+24]
    fdivrp st1, st0
    fst dword [eax+40]
    fmul dword [esp+20]
    fchs
    fstp dword [eax+56]

    fld dword [esp+12]
    fmul dword [_D3DUFloat05]
    fsincos
    fdivrp st1, st0
    fst dword [eax+20]
    fdiv dword [esp+16]
    fstp dword [eax+0]

    mov esi, dword [_D3DUFloat0]
    mov dword [eax+60], esi
    mov esi, dword [_D3DUFloat1]
    mov dword [eax+44], esi

    pop esi
    ret 20

; D3DMATRIX *D3DUMatrixPerspectiveFovLH( D3DMATRIX *pOut, FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf )
;  {
;    FLOAT Q = zf / ( zf - zn );
;    D3DUMatrixCopy( pOut, &D3DUMatrixIdentity );
;    pOut->_11 = fcos( fovy / 2.0f ) / fsin( fovy / 2.0f ) / Aspect;
;    pOut->_22 = fcos( fovy / 2.0f ) / fsin( fovy / 2.0f );
;    pOut->_33 = Q;
;    pOut->_43 = - zn * Q;
;    pOut->_34 = 1.0f;
;    pOut->_44 = 0.0f;
;    return pOut;
;   }

; ---------------------------------------------------------------------------------------------------------------------------------------
;   D3DMATRIX* D3DUMatrixOrthoLH( D3DMATRIX* pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf );
; ---------------------------------------------------------------------------------------------------------------------------------------

_D3DUMatrixOrthoLH@20:
    push esi
    mov eax, dword [esp+8]

    mov esi, _D3DUMatrixIdentity
    push edi
    mov edi, eax
    push ecx
    mov ecx, 16
    rep movsd
    pop ecx
    pop edi

    fld dword [esp+24]
    fsub dword [esp+20]
    ; fld dword [esp+24]
    fld dword [_D3DUFloat1]
    fdivrp st1, st0
    fst dword [eax+40]
    fmul dword [esp+20]
    fchs
    fstp dword [eax+56]

    fld dword [_D3DUFloat2]
    fld dword [esp+12]
    fdivp st1, st0
    fstp dword [eax+0]
    
    fld dword [_D3DUFloat2]
    fld dword [esp+16]
    fdivp st1, st0
    fstp dword [eax+20]

    pop esi
    ret 20

; ===========================================================================
    SECTION .data
; ===========================================================================

_D3DUFloat05:
    dd 0.5

_D3DUFloat2:
    dd 2.0

_D3DUFloat1:
_D3DUMatrixIdentity:
    dd 1.0, 0.0, 0.0, 0.0
    dd 0.0, 1.0, 0.0, 0.0
    dd 0.0, 0.0, 1.0, 0.0
_D3DUFloat0:
    dd 0.0, 0.0, 0.0, 1.0

_D3DUVec3X:
_D3DUMatrixLookAt:
    dd 1.0, 0.0, 0.0, 0.0
_D3DUVec3Y:
    dd 0.0, 1.0, 0.0, 0.0
_D3DUVec3Z:
    dd 0.0, 0.0, 1.0, 0.0
    dd 0.0, 0.0, 0.0, 1.0

; ===========================================================================
    SECTION .bss
; ===========================================================================
