
#ifndef __FRESH_MINDWORKZ_D3DU8_H
#define __FRESH_MINDWORKZ_D3DU8_H

#include <d3d8.h>

#define D3DU_PI 3.1415926535897932384626433832795f

extern "C" D3DMATRIX D3DUMatrixIdentity;

// ------------------------------------------------------------------------------------------------

extern "C" D3DVECTOR* __stdcall D3DUVec3Create( D3DVECTOR *pOut, FLOAT x, FLOAT y, FLOAT z );
extern "C" D3DVECTOR* __stdcall D3DUVec3Copy( D3DVECTOR *pOut, D3DVECTOR *pV );
extern "C" D3DVECTOR* __stdcall D3DUVec3Add( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 );
extern "C" D3DVECTOR* __stdcall D3DUVec3Sub( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 );
extern "C" D3DVECTOR* __stdcall D3DUVec3Scale( D3DVECTOR *pOut, D3DVECTOR *pV, FLOAT Val );
extern "C" D3DVECTOR* __stdcall D3DUVec3Cross( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 );
extern "C" FLOAT __stdcall D3DUVec3Dot( D3DVECTOR *pV1, D3DVECTOR *pV2 );
extern "C" FLOAT __stdcall D3DUVec3Length( D3DVECTOR *pV );
extern "C" FLOAT __stdcall D3DUVec3LengthSq( D3DVECTOR *pV );
extern "C" D3DVECTOR* __stdcall D3DUVec3Normalize( D3DVECTOR *pOut, D3DVECTOR *pV );

// ------------------------------------------------------------------------------------------------

extern "C" D3DMATRIX* __stdcall D3DUMatrixCopy( D3DMATRIX *pOut, D3DMATRIX *pM );
extern "C" D3DMATRIX* __stdcall D3DUMatrixMultiply( D3DMATRIX *pOut, D3DMATRIX *pM1, D3DMATRIX *pM2 );
extern "C" D3DMATRIX* __stdcall D3DUMatrixTranslation( D3DMATRIX *pOut, FLOAT x, FLOAT y, FLOAT z );
extern "C" D3DMATRIX* __stdcall D3DUMatrixRotationX( D3DMATRIX *pOut, FLOAT Angle );
extern "C" D3DMATRIX* __stdcall D3DUMatrixRotationY( D3DMATRIX *pOut, FLOAT Angle );
extern "C" D3DMATRIX* __stdcall D3DUMatrixRotationZ( D3DMATRIX *pOut, FLOAT Angle );
extern "C" D3DMATRIX* __stdcall D3DUMatrixScaling( D3DMATRIX *pOut, FLOAT sx, FLOAT sy, FLOAT sz );
extern "C" D3DMATRIX* __stdcall D3DUMatrixLookAtLH( D3DMATRIX *pOut, D3DVECTOR *pEye, D3DVECTOR *pAt, D3DVECTOR *pUp );
extern "C" D3DMATRIX* __stdcall D3DUMatrixPerspectiveFovLH( D3DMATRIX *pOut, FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf );
extern "C" D3DMATRIX* __stdcall D3DUMatrixOrthoLH( D3DMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf );

#endif