
#ifndef __RUBIC_H
#define __RUBIC_H

// ---------- Rubic.

Object Rubic;
Vect RubicVect[ 64 ];
Face RubicFace[ 64 ];

void Rubic_Init( void )
  {
    Rubic.Faces = (Face*) RubicFace;
    Rubic.Vects = (Vect*) RubicVect;
   }

void Rubic_Draw( float Timer )
  {
    // ---------- Generate Object.

    Col = 1.0f;

    F = 0;
    V = 0;

    Rubic.Faces[ F ].Type = 3;
    Rubic.Faces[ F ].A = V;
    Rubic.Faces[ F ].B = V+1;
    Rubic.Faces[ F ].C = V+2;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+1 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+2 ];
    Rubic.Faces[ F ].ColR = 0.286f;
    Rubic.Faces[ F ].ColG = 0.345f;
    Rubic.Faces[ F ].ColB = 0.372f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 3;
    Rubic.Faces[ F ].A = V+3;
    Rubic.Faces[ F ].B = V+4;
    Rubic.Faces[ F ].C = V+5;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+3 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+4 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+5 ];
    Rubic.Faces[ F ].ColR = 0.286f;
    Rubic.Faces[ F ].ColG = 0.345f;
    Rubic.Faces[ F ].ColB = 0.372f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 3;
    Rubic.Faces[ F ].A = V+6;
    Rubic.Faces[ F ].B = V+7;
    Rubic.Faces[ F ].C = V+8;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+6 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+7 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+8 ];
    Rubic.Faces[ F ].ColR = 0.286f;
    Rubic.Faces[ F ].ColG = 0.345f;
    Rubic.Faces[ F ].ColB = 0.372f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 3;
    Rubic.Faces[ F ].A = V+9;
    Rubic.Faces[ F ].B = V+10;
    Rubic.Faces[ F ].C = V+11;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+9 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+10 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+11 ];
    Rubic.Faces[ F ].ColR = 0.286f;
    Rubic.Faces[ F ].ColG = 0.345f;
    Rubic.Faces[ F ].ColB = 0.372f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 3;
    Rubic.Faces[ F ].A = V+12;
    Rubic.Faces[ F ].B = V+13;
    Rubic.Faces[ F ].C = V+14;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+12 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+13 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+14 ];
    Rubic.Faces[ F ].ColR = 0.286f;
    Rubic.Faces[ F ].ColG = 0.345f;
    Rubic.Faces[ F ].ColB = 0.372f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 3;
    Rubic.Faces[ F ].A = V+15;
    Rubic.Faces[ F ].B = V+16;
    Rubic.Faces[ F ].C = V+17;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+15 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+16 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+17 ];
    Rubic.Faces[ F ].ColR = 0.286f;
    Rubic.Faces[ F ].ColG = 0.345f;
    Rubic.Faces[ F ].ColB = 0.372f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 3;
    Rubic.Faces[ F ].A = V+18;
    Rubic.Faces[ F ].B = V+19;
    Rubic.Faces[ F ].C = V+20;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+18 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+19 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+20 ];
    Rubic.Faces[ F ].ColR = 0.286f;
    Rubic.Faces[ F ].ColG = 0.345f;
    Rubic.Faces[ F ].ColB = 0.372f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 3;
    Rubic.Faces[ F ].A = V+21;
    Rubic.Faces[ F ].B = V+22;
    Rubic.Faces[ F ].C = V+23;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+21 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+22 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+23 ];
    Rubic.Faces[ F ].ColR = 0.286f;
    Rubic.Faces[ F ].ColG = 0.345f;
    Rubic.Faces[ F ].ColB = 0.372f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+2;
    Rubic.Faces[ F ].B = V+5;
    Rubic.Faces[ F ].C = V+11;
    Rubic.Faces[ F ].D = V+8;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+2 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+5 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+11 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+8 ];
    Rubic.Faces[ F ].ColR = 0.404f;
    Rubic.Faces[ F ].ColG = 0.502f;
    Rubic.Faces[ F ].ColB = 0.522f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+14;
    Rubic.Faces[ F ].B = V+17;
    Rubic.Faces[ F ].C = V+23;
    Rubic.Faces[ F ].D = V+20;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+14 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+17 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+23 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+20 ];
    Rubic.Faces[ F ].ColR = 0.404f;
    Rubic.Faces[ F ].ColG = 0.502f;
    Rubic.Faces[ F ].ColB = 0.522f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+1;
    Rubic.Faces[ F ].B = V+4;
    Rubic.Faces[ F ].C = V+16;
    Rubic.Faces[ F ].D = V+13;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+1 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+4 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+16 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+13 ];
    Rubic.Faces[ F ].ColR = 0.404f;
    Rubic.Faces[ F ].ColG = 0.502f;
    Rubic.Faces[ F ].ColB = 0.522f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+3;
    Rubic.Faces[ F ].B = V+9;
    Rubic.Faces[ F ].C = V+21;
    Rubic.Faces[ F ].D = V+15;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+3 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+9 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+21 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+15 ];
    Rubic.Faces[ F ].ColR = 0.404f;
    Rubic.Faces[ F ].ColG = 0.502f;
    Rubic.Faces[ F ].ColB = 0.522f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+7;
    Rubic.Faces[ F ].B = V+10;
    Rubic.Faces[ F ].C = V+22;
    Rubic.Faces[ F ].D = V+19;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+7 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+10 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+22 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+19 ];
    Rubic.Faces[ F ].ColR = 0.404f;
    Rubic.Faces[ F ].ColG = 0.502f;
    Rubic.Faces[ F ].ColB = 0.522f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V;
    Rubic.Faces[ F ].B = V+6;
    Rubic.Faces[ F ].C = V+18;
    Rubic.Faces[ F ].D = V+12;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+6 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+18 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+12 ];
    Rubic.Faces[ F ].ColR = 0.404f;
    Rubic.Faces[ F ].ColG = 0.502f;
    Rubic.Faces[ F ].ColB = 0.522f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+1;
    Rubic.Faces[ F ].B = V+2;
    Rubic.Faces[ F ].C = V+5;
    Rubic.Faces[ F ].D = V+4;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+1 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+2 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+5 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+4 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+0;
    Rubic.Faces[ F ].B = V+2;
    Rubic.Faces[ F ].C = V+8;
    Rubic.Faces[ F ].D = V+6;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+0 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+2 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+8 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+6 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+3;
    Rubic.Faces[ F ].B = V+5;
    Rubic.Faces[ F ].C = V+11;
    Rubic.Faces[ F ].D = V+9;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+3 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+5 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+11 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+9 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+7;
    Rubic.Faces[ F ].B = V+8;
    Rubic.Faces[ F ].C = V+11;
    Rubic.Faces[ F ].D = V+10;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+7 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+8 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+11 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+10 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+15;
    Rubic.Faces[ F ].B = V+17;
    Rubic.Faces[ F ].C = V+23;
    Rubic.Faces[ F ].D = V+21;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+15 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+17 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+23 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+21 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+13;
    Rubic.Faces[ F ].B = V+14;
    Rubic.Faces[ F ].C = V+17;
    Rubic.Faces[ F ].D = V+16;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+13 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+14 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+17 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+16 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+12;
    Rubic.Faces[ F ].B = V+14;
    Rubic.Faces[ F ].C = V+20;
    Rubic.Faces[ F ].D = V+18;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+12 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+14 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+20 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+18 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+19;
    Rubic.Faces[ F ].B = V+20;
    Rubic.Faces[ F ].C = V+23;
    Rubic.Faces[ F ].D = V+22;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+19 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+20 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+23 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+22 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V;
    Rubic.Faces[ F ].B = V+1;
    Rubic.Faces[ F ].C = V+13;
    Rubic.Faces[ F ].D = V+12;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+1 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+13 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+12 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+3;
    Rubic.Faces[ F ].B = V+4;
    Rubic.Faces[ F ].C = V+16;
    Rubic.Faces[ F ].D = V+15;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+3 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+4 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+16 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+15 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+9;
    Rubic.Faces[ F ].B = V+10;
    Rubic.Faces[ F ].C = V+22;
    Rubic.Faces[ F ].D = V+21;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+9 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+10 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+22 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+21 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    Rubic.Faces[ F ].Type = 4;
    Rubic.Faces[ F ].A = V+6;
    Rubic.Faces[ F ].B = V+7;
    Rubic.Faces[ F ].C = V+19;
    Rubic.Faces[ F ].D = V+18;
    Rubic.Faces[ F ].pA = &Rubic.Vects[ V+6 ];
    Rubic.Faces[ F ].pB = &Rubic.Vects[ V+7 ];
    Rubic.Faces[ F ].pC = &Rubic.Vects[ V+19 ];
    Rubic.Faces[ F ].pD = &Rubic.Vects[ V+18 ];
    Rubic.Faces[ F ].ColR = 0.345f;
    Rubic.Faces[ F ].ColG = 0.423f;
    Rubic.Faces[ F ].ColB = 0.447f;
    Rubic.Faces[ F ].ColA = 0.900f;
    Rubic.Faces[ F++ ].Shade = Col;

    // Vertex( & ( Rubic.Vects[ V++ ] ), i - 0.58f, j - 0.58f, k - 0.58f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.45f, 0.41f, 0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.41f, 0.45f, 0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.41f, 0.41f, 0.45f );
    // Vertex( & ( Rubic.Vects[ V++ ] ), i - 1.42f, j - 0.58f, k - 0.58f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.45f, 0.41f, 0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.41f, 0.45f, 0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.41f, 0.41f, 0.45f );
    // Vertex( & ( Rubic.Vects[ V++ ] ), i - 0.58f, j - 1.42f, k - 0.58f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.45f, -0.41f, 0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.41f, -0.45f, 0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.41f, -0.41f, 0.45f );
    // Vertex( & ( Rubic.Vects[ V++ ] ), i - 1.42f, j - 1.42f, k - 0.58f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.45f, -0.41f, 0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.41f, -0.45f, 0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.41f, -0.41f, 0.45f );
    // Vertex( & ( Rubic.Vects[ V++ ] ), i - 0.58f, j - 0.58f, k - 1.42f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.45f, 0.41f, -0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.41f, 0.45f, -0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.41f, 0.41f, -0.45f );
    // Vertex( & ( Rubic.Vects[ V++ ] ), i - 1.42f, j - 0.58f, k - 1.42f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.45f, 0.41f, -0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.41f, 0.45f, -0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.41f, 0.41f, -0.45f );
    // Vertex( & ( Rubic.Vects[ V++ ] ), i - 0.58f, j - 1.42f, k - 1.42f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.45f, -0.41f, -0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.41f, -0.45f, -0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), 0.41f, -0.41f, -0.45f );
    // Vertex( & ( Rubic.Vects[ V++ ] ), i - 1.42f, j - 1.42f, k - 1.42f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.45f, -0.41f, -0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.41f, -0.45f, -0.41f );
    Vertex( & ( Rubic.Vects[ V++ ] ), -0.41f, -0.41f, -0.45f );

    Rubic.NumFaces = F;
    Rubic.NumVects = V;

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective( 50.0f, 640.0f / 480.0f, 1.0f, 100.0f ); 

    Camp.X = 4.0f * Fsin( Timer * 0.0029f );
    Camp.Y = 4.0f * Fcos( Timer * 0.0029f );
    Camp.Z = Fsin( Timer * 0.0094f );

    gluLookAt( Camp.X, Camp.Y, Camp.Z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f );

    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
    glEnable( GL_DEPTH_TEST );
    glDisable( GL_BLEND );
  
    for ( int i = 0; i < 3; i++ )
      for ( int j = 0; j < 3; j++ )
        for ( int k = 0; k < 3; k++ )
          DrawObject( (Object*) ( &Rubic ), (float) ( i-1 ), (float) ( j-1 ), (float) ( k-1 ));
   }

#endif
