local M={}
local images={}
local cachedTime=0
function M.load()
images={}
for i=1,10 do
local filename=string.format("3dlogo-%02d.png",i)
local img=love.graphics.newImage(filename)
img:setFilter("nearest","nearest")
images[i]=img end
cachedTime=0 end
function M.update(dt,timePassed)
cachedTime=timePassed or cachedTime end
local function currentFrame()
if #images==0 then return nil end
local idx=(math.floor(cachedTime/0.2400)%10)+1
return images[idx] end
local function orbitPosition(img)
local W,H=love.graphics.getWidth(),love.graphics.getHeight()
local iw,ih=img:getWidth(),img:getHeight()
local cx,cy=W*0.5,H*0.5
local maxR=math.min(cx-16-iw*0.5,cy-16-ih*0.5)
local r=math.max(0,maxR)
local phase=(cachedTime/5.40)*(2*math.pi)
local x=cx+r*math.cos(phase)-iw*0.5
local y=cy+r*math.sin(phase)-ih*0.5
return x,y end
function M.draw()
local img=currentFrame()
if not img then return end
local x,y=orbitPosition(img)
love.graphics.setColor(1,1,1,1)
love.graphics.draw(img,math.floor(x+0.5),math.floor(y+0.5)) end
return M
