
.include "fb32x32.inc"

.include "globals.inc"

scrollbuffer   := FRAMEBUFFER+$300

;  9 lines type: code, music, gfx
;
; 10 lines lemmings
;  4 lines graphics
;  9 lines names

.segment "GFXDATA"

credits_hardware_gfx:
   .byte $af,$00,$af,$00,$af,$af,$af,$00,$af,$af,$af,$00,$af,$af,$00,$00,$af,$00,$00,$00,$af,$00,$af,$af,$af,$00,$af,$af,$af,$00,$af,$af
   .byte $af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$00,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00
   .byte $af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$00,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00
   .byte $af,$af,$af,$00,$af,$af,$af,$00,$af,$af,$00,$00,$af,$00,$af,$00,$af,$00,$00,$00,$af,$00,$af,$af,$af,$00,$af,$af,$00,$00,$af,$af
   .byte $af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00
   .byte $af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$af,$00,$af,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00
   .byte $af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$af,$00,$00,$af,$00,$00,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$00,$af,$af
   .byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00

background:
   .byte $27,$27,$7a,$7a,$27,$89,$8a,$8a,$8a,$79,$7a,$7a,$7a,$7a,$8a,$79,$7a,$27,$27,$79,$8a,$8a,$8a,$79,$8a,$89,$8a,$8a,$7a,$79,$79,$8a
   .byte $7a,$79,$89,$27,$27,$79,$8a,$79,$89,$89,$7a,$27,$8a,$8a,$27,$7a,$27,$89,$27,$89,$8a,$27,$7a,$8a,$79,$8a,$79,$27,$7a,$8a,$79,$8a
   .byte $6c,$6c,$6c,$27,$27,$27,$27,$27,$27,$6d,$6c,$27,$6c,$27,$6c,$6c,$27,$6c,$27,$27,$27,$6d,$6d,$27,$6d,$6d,$6c,$6c,$6d,$27,$6c,$27
   .byte $79,$8a,$89,$79,$8a,$89,$89,$89,$8a,$7a,$79,$27,$8a,$8a,$79,$27,$79,$27,$7a,$8a,$8a,$8a,$8a,$7a,$27,$79,$8a,$8a,$27,$79,$89,$79
   .byte $79,$79,$27,$8a,$79,$89,$89,$89,$79,$79,$8a,$27,$27,$79,$79,$27,$8a,$7a,$7a,$79,$27,$27,$8a,$79,$7a,$89,$8a,$79,$27,$8a,$8a,$8a
   .byte $89,$8a,$7a,$79,$89,$79,$27,$8a,$27,$79,$79,$79,$79,$8a,$27,$79,$7a,$27,$79,$27,$7a,$79,$89,$8a,$8a,$8a,$79,$8a,$79,$79,$7a,$27
   .byte $79,$89,$89,$89,$8a,$89,$7a,$89,$7a,$7a,$7a,$89,$8a,$89,$7a,$79,$7a,$8a,$79,$7a,$7a,$79,$89,$7a,$8a,$8a,$8a,$27,$7a,$79,$7a,$7a
   .byte $79,$79,$79,$8a,$8a,$8a,$79,$79,$7a,$27,$8a,$79,$27,$79,$8a,$79,$8a,$8a,$79,$79,$8a,$79,$89,$7a,$7a,$7a,$27,$27,$27,$79,$7a,$7a
   .byte $89,$27,$79,$79,$8a,$79,$8a,$27,$27,$7a,$7a,$8a,$8a,$79,$89,$8a,$7a,$8a,$79,$8a,$8a,$7a,$79,$27,$27,$7a,$79,$8a,$8a,$79,$7a,$27
   .byte $89,$79,$27,$8a,$79,$8a,$8a,$79,$7a,$27,$8a,$8a,$89,$27,$79,$79,$8a,$79,$27,$79,$8a,$27,$8a,$8a,$79,$7a,$27,$79,$8a,$79,$79,$27
   .byte $79,$27,$79,$27,$79,$79,$7a,$27,$79,$8a,$79,$8a,$79,$89,$27,$27,$79,$27,$8a,$27,$79,$89,$7a,$27,$7a,$27,$79,$8a,$8a,$8a,$8a,$8a
   .byte $79,$27,$27,$79,$8a,$8a,$8a,$79,$8a,$79,$79,$7a,$7a,$79,$7a,$27,$27,$79,$79,$8a,$8a,$79,$27,$8a,$79,$8a,$8a,$7a,$89,$8a,$79,$8a
   .byte $8a,$8a,$79,$8a,$79,$8a,$79,$8a,$8a,$79,$89,$79,$27,$79,$8a,$79,$8a,$79,$27,$7a,$79,$89,$8a,$79,$27,$7a,$8a,$89,$27,$27,$8a,$27

fadecoltab:
   .byte $0f,$00,$0e,$01,$0d,$02,$0c,$03,$0b,$04,$0a,$05,$09,$06,$08,$07

.segment "DATA"
credits_code_hd:
   .byte "CODE",0
credits_code_sc:
   .byte "SVOLLI",0
credits_gfx_hd:
   .byte "GRAFIX",0
credits_gfx_sc:
   .byte "TITUS & VETO",0
credits_music_hd:
   .byte "MUSIC",0
credits_music_sc:
   .byte "SKYRUNNER",0
credits_hardware_sc:
   .byte "SVOLLI & HIS DAD",0

; drawing is only done on even frames, odd frames for update of gfx data
myschedule:
   .word $0000, credits_init
   .word $0001, credits_code
   .word $0020, credits_scroll
   .word $00ff, credits_gfx
   .word $0120, credits_scroll
   .word $01ff, credits_music
   .word $0220, credits_scroll
   .word $02ff, credits_hardware
   .word $0320, credits_scroll
   .word $03ff, schedulenext

.segment "CODE"

xstart   = localram+0

credits:
   lda   #<myschedule
   ldx   #>myschedule
   jmp   subschedule


credits_recolor:
   lda   frmcnt+0
   bpl   :+
   eor   #$ff
:
   lsr
   cmp   #$0a
   bcc   :+
   lda   #$0a
:
   tay
   ldx   #$00
:
   lda   FRAMEBUFFER+$020,x
   beq   :+
   and   #$f0
   ora   fadecoltab,y
   sta   FRAMEBUFFER+$020,x
:
   inx
   bne   :--
   rts

credits_setfb:
   ldx   #$00
:
   stz   FRAMEBUFFER+$020,x
   inx
   bne   :-

   ldx   #>(FRAMEBUFFER+$020)
   jmp   text_setfb


credits_code:
   lda   #<credits_code_sc
   ldx   #>credits_code_sc
   jsr   scroll_settext
   lda   #<(FRAMEBUFFER+$026)
   ldy   #$df
   jsr   credits_setfb
   lda   #<credits_code_hd
   ldx   #>credits_code_hd
   jsr   text_draw
   bra   credits_draw


credits_gfx:
   lda   #<credits_gfx_sc
   ldx   #>credits_gfx_sc
   jsr   scroll_settext
   lda   #<(FRAMEBUFFER+$021)
   ldy   #$ff
   jsr   credits_setfb
   lda   #<credits_gfx_hd
   ldx   #>credits_gfx_hd
   jsr   text_draw
   bra   credits_draw


credits_music:
   lda   #<credits_music_sc
   ldx   #>credits_music_sc
   jsr   scroll_settext
   lda   #<(FRAMEBUFFER+$024)
   ldy   #$ef
   jsr   credits_setfb
   lda   #<credits_music_hd
   ldx   #>credits_music_hd
   jsr   text_draw
   bra   credits_draw


credits_hardware:
   ldx   #$00
:
   lda   credits_hardware_gfx,x
   sta   FRAMEBUFFER+$020,x
   inx
   bne   :-

   lda   #<credits_hardware_sc
   ldx   #>credits_hardware_sc
   jsr   scroll_settext
   bra   credits_draw


credits_init:
   lda   #$08
   sta   FB32X32_COLMAP

   jsr   clearfb
   jsr   showfb

   lda   #<scrollbuffer
   ldx   #>scrollbuffer
   ldy   #$20
   jsr   scroll_setfb

   lda   #$03
   ldx   #$00
   ldy   #$5f
   jsr   scroll_setcolors

   bra   credits_draw


credits_scroll:
   lda   frmcnt+0
   and   #$01
   bne   :+
   rts
:
   jsr   scroll_update
credits_draw:
   lda   frmcnt+0
   and   #$01
   bne   :+
   rts
:
   jsr   credits_recolor

   ; draw lemmings
   ldy   #$09
   lda   frmcnt+0
   lsr
   ldx   #$03
   jsr   lemming
   inc
   ldx   #$0d
   jsr   lemming
   inc
   ldx   #$17
   jsr   lemming

   ; draw title
   stz   FB32X32_SRC+0
   lda   #>FRAMEBUFFER
   sta   FB32X32_SRC+1

   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y

   lda   #$08
   sta   FB32X32_HEIGHT
   lda   #$1f
   sta   FB32X32_WIDTH
   sta   FB32X32_STEP
   stz   FB32X32_COPYN

   lda   frmcnt+0
   lsr
   and   #$1f
   sta   xstart

   clc
   adc   #<background
   sta   FB32X32_SRC+0
   lda   #>background
   adc   #$00
   sta   FB32X32_SRC+1

   lda   #$00
   sta   FB32X32_DEST_X
   lda   #$13
   sta   FB32X32_DEST_Y
   sec
   lda   #$1f
   sbc   xstart
   sta   FB32X32_WIDTH
   lda   #$1f
   sta   FB32X32_STEP
   lda   #$0c
   sta   FB32X32_HEIGHT
   stz   FB32X32_COPYN

   lda   xstart
   beq   @no2ndcopy

   ; graphics is split
   lda   #<background
   sta   FB32X32_SRC+0
   lda   #>background
   sta   FB32X32_SRC+1

   sec
   lda   #$20
   sbc   xstart
   sta   FB32X32_DEST_X
   ; DEST_Y from previous
   lda   xstart
   dec
   sta   FB32X32_WIDTH
   stz   FB32X32_COPYN
@no2ndcopy:

   ; draw scrolltext
   stz   FB32X32_SRC+0
   lda   #>scrollbuffer
   sta   FB32X32_SRC+1

   stz   FB32X32_DEST_X
   lda   #$17
   sta   FB32X32_DEST_Y

   lda   #$07
   sta   FB32X32_HEIGHT
   lda   #$1f
   sta   FB32X32_WIDTH
   sta   FB32X32_STEP

   stz   FB32X32_TCOL

   lda   #$01
   sta   FB32X32_COPY
   rts
