LOOPING equ 0

	org #8000

	;test code

begin

	ld hl,music_data
	call play
	ret


play
    di
	ld (_sequence_pointer),hl
    exx
    push hl
    push iy
    ld iy,0
    ld (_oldSP),sp

_read_sequence
_sequence_pointer equ $+1
    ld sp,0
_skip_sp_read
    pop hl
    ld a,h
    or l

    jr nz,_set_sp
IF LOOPING = 1
    pop hl
    ld sp,hl
    jr _skip_sp_read
ELSE
    jp _exit_player
ENDIF

_set_sp
    ld (_sequence_pointer),sp
    ld (_pattern_pointer),hl


_read_pattern
    in a,(#fe)
    cpl
    and #1f
    jp nz,_exit_player

    ld (_phase_ch2a),sp

_pattern_pointer equ $+1
    ld sp,0
    pop af                      ; F = ctrl bits, A = step length
    jr z,_read_sequence


    jr c,_no_update_ch1

    pop de                      ; DE = phase offset ch1a
    pop hl
    ld (_fdiv_ch1a),hl
    pop hl
    ld (_fdiv_ch1),hl
    ld bc,0                     ; phase ch1

_no_update_ch1
    jp pe,_no_update_ch2

    pop hl
    ld (_phase_ch2a),hl
    pop hl
    ld (_fdiv_ch2a),hl
    exx
    pop bc                      ; BC' = fdiv_ch2
    ld ix,0                     ; phase ch2
    exx

_no_update_ch2
    jp m,_no_update_ch3
    exx
    pop de                      ; fdiv_ch3
    pop hl                      ; sweep_enable << 8 | duty ch3
    ex af,af'
    ld a,h
    ld (_duty_sweep_ch3_enable),a
    ld a,l
    or a
    jr z,_no_duty_reset
    ld iyl,a

_no_duty_reset
    ex af,af'
    ld hl,0
    exx

_no_update_ch3
    ex af,af'

    pop hl                      ;       fetch click drum
    ld a,l
    or a
    jp z,_drum_return

    push hl
    srl a                       ;       row length correction
    jr nc,_no_half_row

    ld iyh,#80

_no_half_row
    neg
    ld l,a
    ex af,af'
    add a,l
    ex af,af'

    jp _pwm_init

_drum_return
    ld (_pattern_pointer),sp

_phase_ch2a equ $+1
    ld sp,0


_play_note
_fdiv_ch1a equ $+1
    ld hl,0                     ; 10

    out (#fe),a                 ; 11 __ 62 v2

    add hl,bc                   ; 11
    ld b,h                      ; 4
    ld c,l                      ; 4
    ld a,b                      ; 4

_fdiv_ch1 equ $+1
    ld hl,0                     ; 10

    out (#fe),a                 ; 11__ 44 v3

    add hl,de                   ; 11
    ld a,h                      ; 4
    out (#fe),a                 ; 11__ 26 v1a

    ex de,hl                    ; 4

_fdiv_ch2a equ $+1
    ld hl,0                     ; 10
    add hl,sp                   ; 11
    ld sp,hl                    ; 6
    ld a,h                      ; 4

    exx                         ; 4
    add ix,bc                   ; 15            fdiv_ch2

    out (#fe),a                 ; 11__ 65 v1

    ld a,ixh                    ; 8
    out (#fe),a                 ; 11__ 19 v2a

    add hl,de                   ; 11            fdiv_ch3
    ld a,h                      ; 4
    add a,iyl                   ; 8             duty -> could theoretically be replaced with noise
    or h                        ; 4

    exx                         ; 4
    dec iyh                     ; 8
    jp nz,_play_note            ; 10 --- 224


    ex af,af'
    dec a
    jp z,_read_pattern

_duty_sweep_ch3_enable          ;               #fd to enable, 0 to disable
    nop                         ;               #fd, inc l = inc iyl
    inc l                       ;               inc l by itself does nothing
    ex af,af'
    jp _play_note


_exit_player
_oldSP equ $+1
    ld sp,0
    pop iy
    pop hl
    exx
    ei
    ret



_drums

_pwm_init
    ;; ld (_old_HL),hl             ; 16
    ld (_old_BC),bc             ; 20
    ld (_old_DE),de             ; 20
    ld (_old_A),a               ; 13

    pop de                      ; 10    volume/length
    pop hl                      ; 10    pwm data pointer

    ld a,d                      ; 4
    ld (_volume_restore),a      ; 13
    ld c,#fe                    ; 7

    ld d,(hl)                   ; 7
    xor a                       ; 4
    ld b,#fe                    ; 7     timer lo, skip 2 loops to adjust time
                                ; init 131

_play_drum0
    nop                         ; 4
_play_drum
    out (#fe),a                 ; 11__32

    rlca                        ; 4
    rlca                        ; 4
    dec d                       ; 4
    jr nz,_wait                 ; 12/7

_volume_restore equ $+1         ;       load next sample byte
    xor 0                       ; 7
    inc hl                      ; 6
    ld d,(hl)                   ; 7
    ld d,(hl)                   ; 7     timing
    ld d,(hl)                   ; 7     timing

_wait_ret
    out (#fe),a                 ; 11__64

    rrca                        ; 4
    out (c),a                   ; 12__16
    rrca                        ; 4

    djnz _play_drum0            ; 13 --- 112     update length counter lo-byte

    dec e                       ; 4
    jp nz,_play_drum            ; 10


_drum_exit
_old_A equ $+1
    ld a,0                      ; 7
;; _old_HL equ $+1
;;     ld hl,0                     ; 10
_old_BC equ $+1
    ld bc,0                     ; 10
_old_DE equ $+1
    ld de,0                     ; 10

_exit_drum
    jp _drum_return		      ; 10 -- exit 61, init+exit 192


_wait                           ;+12
    inc d                       ; 4     check for sample end
    jr z,_disable_drum          ; 12
    dec d                       ; 4
    ds 2                        ; 8
    jr _wait_ret                ; 12 -- 52


_wait_for_drum_end
    ds 2                        ; 8
    ex (sp),hl                  ; 19
    ex (sp),hl                  ; 19
    ex (sp),hl                  ; 19
    ex (sp),hl                  ; 19

_disable_drum
    xor a                       ; 4
    out (#fe),a                 ; 11
    djnz _wait_for_drum_end     ; 13

    dec e
    jp nz,_wait_for_drum_end+1

    jp _drum_return

;compiled music data

music_data
.seq:
	dw .pattern1
.loop:
	dw .pattern2
	dw 0
	dw .loop
.pattern1
.song
	dw #700,#fe0,#6c,#6c,#0,#36,#0,#0,#20,0
	dw #784,#fe0,#81,#81,0
	dw #784,#fe0,#91,#91,0
	dw #784,#fe0,#a3,#a3,0
	dw #784,#fe0,#6c,#0,0
	dw #784,#fe0,#81,#0,0
	dw #784,#fe0,#91,#0,0
	dw #784,#fe0,#a3,#0,0
	dw #784,#fe0,#6c,#6c,0
	dw #784,#fe0,#81,#81,0
	dw #784,#fe0,#91,#91,0
	dw #784,#fe0,#a3,#a3,0
	dw #784,#fe0,#6c,#0,0
	dw #784,#fe0,#81,#0,0
	dw #784,#fe0,#91,#0,0
	dw #784,#fe0,#a3,#0,0
	dw #784,#fc0,#6c,#6c,0
	dw #784,#fc0,#81,#81,0
	dw #784,#fc0,#91,#91,0
	dw #784,#fc0,#a3,#a3,0
	dw #784,#fc0,#6c,#0,0
	dw #784,#fc0,#81,#0,0
	dw #784,#fc0,#91,#0,0
	dw #784,#fc0,#a3,#0,0
	dw #784,#fc0,#6c,#6c,0
	dw #784,#fc0,#81,#81,0
	dw #784,#fc0,#91,#91,0
	dw #784,#fc0,#a3,#a3,0
	dw #784,#fc0,#6c,#0,0
	dw #784,#fc0,#81,#0,0
	dw #784,#fc0,#91,#0,0
	dw #784,#fc0,#a3,#0,0
	dw #784,#f80,#6c,#6c,0
	dw #784,#f80,#81,#81,0
	dw #784,#f80,#91,#91,0
	dw #784,#f80,#a3,#a3,0
	dw #784,#f80,#6c,#0,0
	dw #784,#f80,#81,#0,0
	dw #784,#f80,#91,#0,0
	dw #784,#f80,#a3,#0,0
	dw #784,#f80,#6c,#6c,0
	dw #784,#f80,#81,#81,0
	dw #784,#f80,#91,#91,0
	dw #784,#f80,#a3,#a3,0
	dw #784,#f80,#6c,#0,0
	dw #784,#f80,#81,#0,0
	dw #784,#f80,#91,#0,0
	dw #784,#f80,#a3,#0,0
	dw #784,#f00,#6c,#6c,0
	dw #784,#f00,#81,#81,0
	dw #784,#f00,#91,#91,0
	dw #784,#f00,#a3,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#6c,#6c,0
	dw #784,#f00,#81,#81,0
	dw #784,#f00,#91,#91,0
	dw #784,#f00,#a3,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #700,#f00,#0,#6c,#0,#0,#0,#36,#fd0c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#d9,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#d9,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#ac,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#ac,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#66,0
	dw #784,#f00,#0,#7a,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#66,#0,0
	dw #784,#f00,#7a,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#0,#66,0
	dw #784,#f00,#0,#7a,0
	dw #784,#f00,#0,#ac,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#66,#0,0
	dw #784,#f00,#7a,#0,0
	dw #784,#f00,#ac,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#ac,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#ac,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#d9,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#d9,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#ac,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#ac,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#66,0
	dw #784,#f00,#0,#7a,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#0,#cd,0
	dw #784,#f00,#66,#0,0
	dw #784,#f00,#7a,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#cd,#0,0
	dw #784,#f00,#0,#66,0
	dw #784,#f00,#0,#7a,0
	dw #784,#f00,#0,#ac,0
	dw #784,#f00,#0,#f4,0
	dw #784,#f00,#66,#0,0
	dw #784,#f00,#7a,#0,0
	dw #784,#f00,#ac,#0,0
	dw #784,#f00,#f4,#0,0
	dw #784,#f00,#0,#d9,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#d9,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#0,#d9,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#d9,#0,0
	dw #704,#fe0,#6c,#6c,#36,#fd0c,0
	dw #784,#fe0,#81,#81,0
	dw #784,#fe0,#91,#91,0
	dw #784,#fe0,#a3,#a3,0
	dw #784,#fe0,#6c,#0,0
	dw #784,#fe0,#81,#0,0
	dw #784,#fe0,#91,#0,0
	dw #784,#fe0,#d9,#0,0
	dw #784,#fe0,#6c,#6c,0
	dw #784,#fe0,#81,#81,0
	dw #784,#fe0,#91,#91,0
	dw #784,#fe0,#a3,#a3,0
	dw #784,#fe0,#6c,#0,0
	dw #784,#fe0,#81,#0,0
	dw #784,#fe0,#91,#0,0
	dw #784,#fe0,#a3,#0,0
	dw #784,#fc0,#6c,#6c,0
	dw #784,#fc0,#81,#81,0
	dw #784,#fc0,#91,#91,0
	dw #784,#fc0,#a3,#a3,0
	dw #784,#fc0,#6c,#0,0
	dw #784,#fc0,#81,#0,0
	dw #784,#fc0,#91,#0,0
	dw #784,#fc0,#a3,#0,0
	dw #784,#fc0,#6c,#6c,0
	dw #784,#fc0,#81,#81,0
	dw #784,#fc0,#91,#91,0
	dw #784,#fc0,#a3,#a3,0
	dw #784,#fc0,#6c,#0,0
	dw #784,#fc0,#81,#0,0
	dw #784,#fc0,#91,#0,0
	dw #784,#fc0,#a3,#0,0
	dw #884,#f80,#6c,#6c,0
	dw #884,#f80,#81,#81,0
	dw #884,#f80,#91,#91,0
	dw #884,#f80,#a3,#a3,0
	dw #884,#f80,#6c,#0,0
	dw #884,#f80,#81,#0,0
	dw #884,#f80,#91,#0,0
	dw #884,#f80,#a3,#0,0
	dw #984,#f80,#6c,#6c,0
	dw #984,#f80,#81,#81,0
	dw #984,#f80,#91,#91,0
	dw #984,#f80,#a3,#a3,0
	dw #a84,#f80,#6c,#0,0
	dw #a84,#f80,#81,#0,0
	dw #a84,#f80,#91,#0,0
	dw #a84,#f80,#a3,#0,0
	dw #b84,#f80,#6c,#6c,0
	dw #b84,#f80,#81,#81,0
	dw #c84,#f80,#91,#91,0
	dw #c84,#f80,#a3,#a3,0
	dw #d84,#f80,#6c,#0,0
	dw #e84,#f80,#81,#0,0
	dw #f84,#f80,#91,#0,0
	dw #1084,#f80,#a3,#0,0
	dw #1284,#f80,#6c,#6c,0
	dw #1484,#f80,#81,#81,0
	dw #1684,#f80,#91,#91,0
	dw #1884,#f80,#a3,#a3,0
	dw #584,#f00,#6c,#6c,#1008,.s0
	dw #584,#f00,#81,#81,#1008,.s0
	dw #584,#f00,#91,#91,#1008,.s0
	dw #584,#f00,#a3,#a3,#1008,.s0
	dw #584,#f00,#6c,#0,#2008,.s0
	dw #584,#f00,#81,#0,#2008,.s0
	dw #584,#f00,#91,#0,#2008,.s0
	dw #584,#f00,#a3,#0,#2008,.s0
	dw #584,#f00,#6c,#6c,#3008,.s0
	dw #584,#f00,#81,#81,#3008,.s0
	dw #584,#f00,#91,#91,#3008,.s0
	dw #584,#f00,#a3,#a3,#3008,.s0
	dw #584,#f00,#6c,#0,#4008,.s0
	dw #584,#f00,#81,#0,#4008,.s0
	dw #584,#f00,#91,#0,#4008,.s0
	dw #584,#f00,#a3,#0,#4008,.s0
	dw #400,#f00,#d9,#6c,#0,#81,#1b,#36,#fd0c,#4007,.s0
	dw #484,#f00,#0,#0,#3007,.s0
	dw #484,#f00,#f4,#7a,0
	dw #484,#f00,#6c,#0,0
	dw #484,#f00,#102,#81,0
	dw #484,#f00,#7a,#0,0
	dw #484,#f00,#122,#91,0
	dw #484,#f00,#81,#0,#2007,.s0
	dw #484,#f00,#d9,#6c,#3007,.s0
	dw #484,#f00,#91,#0,0
	dw #484,#f00,#f4,#7a,0
	dw #484,#f00,#6c,#0,0
	dw #484,#f00,#102,#81,0
	dw #484,#f00,#7a,#0,0
	dw #484,#f00,#122,#91,0
	dw #484,#f00,#81,#0,0
	dw #484,#f00,#0,#6c,0
	dw #484,#f00,#91,#0,0
	dw #484,#f00,#0,#7a,0
	dw #484,#f00,#6c,#0,0
	dw #484,#f00,#0,#81,0
	dw #484,#f00,#7a,#0,0
	dw #484,#f00,#0,#91,0
	dw #484,#f00,#81,#0,0
	dw #480,#f00,#0,#6c,#0,#a3,#1b,0
	dw #484,#f00,#91,#0,0
	dw #484,#f00,#0,#7a,0
	dw #484,#f00,#6c,#0,0
	dw #484,#f00,#0,#81,0
	dw #484,#f00,#7a,#0,0
	dw #484,#f00,#0,#91,0
	dw #484,#f00,#81,#0,0
	dw #400,#f00,#0,#6c,#0,#81,#1b,#35,#fd0c,0
	dw #484,#f00,#91,#0,0
	dw #484,#f00,#0,#7a,0
	dw #484,#f00,#6c,#0,0
	dw #484,#f00,#0,#81,0
	dw #484,#f00,#7a,#0,0
	dw #484,#f00,#0,#91,0
	dw #484,#f00,#81,#0,0
	dw #484,#f00,#0,#6c,0
	dw #484,#f00,#91,#0,0
	dw #484,#f00,#0,#7a,0
	dw #484,#f00,#6c,#0,0
	dw #484,#f00,#0,#81,0
	dw #484,#f00,#7a,#0,0
	dw #484,#f00,#0,#91,0
	dw #484,#f00,#81,#0,0
	dw #484,#f00,#d9,#6c,0
	dw #484,#f00,#91,#0,0
	dw #484,#f00,#f4,#7a,0
	dw #484,#f00,#6c,#0,0
	dw #484,#f00,#102,#81,0
	dw #484,#f00,#7a,#0,0
	dw #484,#f00,#122,#91,0
	dw #484,#f00,#81,#0,0
	dw #484,#f00,#d9,#6c,0
	dw #484,#f00,#91,#0,0
	dw #484,#f00,#f4,#7a,#3007,.s0
	dw #484,#f00,#6c,#0,0
	dw #484,#f00,#102,#81,0
	dw #484,#f00,#7a,#0,#1007,.s0
	dw #484,#f00,#122,#91,#1007,.s0
	dw #484,#f00,#81,#0,#1007,.s0
	dw #400,#f00,#0,#0,#0,#81,#1b,#36,#fd0c,#3007,.s0
	dw #484,#f00,#91,#0,#2007,.s0
	dw #484,#f00,#0,#0,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #400,#f00,#0,#0,#0,#0,#0,#0,#fd0c,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #400,#f00,#a3,#0,#0,#81,#1b,#63,#fd0c,#4007,.s0
	dw #405,#64,#fd0c,#3007,.s0
	dw #405,#68,#fd0c,0
	dw #405,#6c,#fd0c,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#2007,.s0
	dw #405,#36,#fd0c,#3007,.s0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #405,#33,#fd0c,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#3007,.s0
	dw #485,0
	dw #485,0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #405,#36,#fd0c,#3007,.s0
	dw #485,#2007,.s0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #400,#f00,#c0,#0,#0,#81,#1b,#63,#fd0c,#4007,.s0
	dw #405,#64,#fd0c,#3007,.s0
	dw #405,#68,#fd0c,0
	dw #405,#6c,#fd0c,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#2007,.s0
	dw #405,#36,#fd0c,#3007,.s0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #404,#f00,#ba,#0,#33,#fd0c,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#3007,.s0
	dw #485,0
	dw #485,0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #404,#f00,#c1,#0,#36,#fd0c,#3007,.s0
	dw #485,#2007,.s0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,0
	dw #485,#1007,.s0
	dw #485,#2007,.s0
	dw #485,0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,0
	dw #485,#4007,.s0
	dw #400,#f00,#102,#0,#0,#d9,#1b,#63,#fd0c,#4007,.s0
	dw #405,#64,#fd0c,#3007,.s0
	dw #405,#68,#fd0c,0
	dw #405,#6c,#fd0c,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#2007,.s0
	dw #405,#36,#fd0c,#3007,.s0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #400,#f00,#f4,#0,#0,#a3,#1b,#33,#fd0c,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#3007,.s0
	dw #485,0
	dw #485,0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #404,#f00,#102,#0,#36,#fd0c,#3007,.s0
	dw #485,#2007,.s0
	dw #485,0
	dw #484,#f00,#f4,#0,0
	dw #485,0
	dw #484,#f00,#102,#0,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#1007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#2007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #485,#4007,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#1005,.s0
	dw #385,#1005,.s0
	dw #385,#1005,.s0
	dw #381,#0,#a3,#0,#1005,.s0
	dw #285,#1003,.s0
	dw #285,#1003,.s0
	dw #285,#1003,.s0
	dw #285,#1003,.s0
	dw #285,#2003,.s0
	dw #285,#2003,.s0
	dw #285,#2003,.s0
	dw #285,#2003,.s0
	dw #185,#3001,.s0
	dw #185,#3001,.s0
	dw #185,#3001,.s0
	dw #185,#3001,.s0
	dw #185,#4001,.s0
	dw #185,#4001,.s0
	dw #185,#4001,.s0
	dw #185,#4001,.s0
	dw #285,#4003,.s0
	dw #285,#4003,.s0
	dw #285,#4003,.s0
	dw #285,#4003,.s0
	dw #300,#f00,#0,#0,#0,#0,#0,#0,#fd0c,#3005,.s0
	dw #385,#3005,.s0
	dw #485,#3007,.s0
	dw #485,#3007,.s0
	dw #585,#2008,.s0
	dw #685,#2008,.s0
	dw #785,#2008,.s0
	dw #885,#2008,.s0
	dw #985,#1008,.s0
	dw #b85,#1008,.s0
	dw #d85,#1008,.s0
	dw #1081,#0,#0,#0,#1008,.s0
	dw #1485,#1008,.s0
	dw #300,#f00,#146,#0,#0,#0,#0,#1b,#fd20,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#159,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#159,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#159,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#159,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#159,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#159,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#159,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#159,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#f4,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#f4,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#f4,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#f4,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#159,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#159,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#159,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#159,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#159,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#159,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#122,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#122,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#159,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#159,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#f4,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#f4,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#a3,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#a3,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#f4,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#f4,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#a3,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#a3,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#f4,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#f4,#0,0
	dw #384,#f00,#cd,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#a3,#0,0
	dw #381,#0,#cd,#0,0
	dw #384,#f00,#146,#0,0
	dw #381,#0,#a3,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#146,#0,0
	dw #384,#f00,#102,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,0
	dw #381,#0,#102,#0,0
	dw #384,#f00,#f4,#0,0
	dw #381,#0,#d9,#0,0
	dw #384,#f00,#d9,#0,#1002,.s1
	dw #381,#0,#f4,#0,#1002,.s1
	dw #384,#f00,#cd,#0,#2002,.s1
	dw #381,#0,#d9,#0,#2002,.s1
	dw #384,#f00,#a3,#0,#3002,.s1
	dw #381,#0,#cd,#0,#3002,.s1
	db #40
.pattern2
	dw #300,#f00,#146,#1b,#0,#0,#0,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#159,#0,#0,#0,#1b,#35,#fd0e,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#0,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#122,#0,#0,#0,#1b,#36,#fd0e,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#0,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#159,#0,#0,#0,#1b,#36,#fd0e,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#0,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#122,#0,#0,#0,#1b,#36,#fd0e,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#0,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#159,#0,#0,#0,#1b,#36,#fd0e,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#0,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#122,#0,#0,#0,#1b,#38,#fd0e,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#0,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#159,#0,#0,#0,#1b,#36,#fd0e,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#0,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#122,#0,#0,#0,#1b,#36,#fd0e,0
	dw #385,0
	dw #384,#f00,#d9,#1b,#3005,.s0
	dw #385,0
	dw #300,#f00,#102,#1b,#0,#1a,#1b,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#35,#fd00,#2002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#2002,.s1
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#0,#36,#fd00,0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd00,0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#0,#36,#fd00,0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd00,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#f4,#0,#36,#fd00,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd00,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1b,#3005,.s0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,0
	dw #385,0
	dw #384,#f00,#d9,#0,#3005,.s0
	dw #385,0
	dw #300,#f00,#122,#1b,#1000,#1a,#1b,#0,#fd00,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#35,#fd20,#2002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,0
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#1b,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,0
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,0
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #381,#1000,#0,#1b,0
	dw #304,#f00,#122,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#38,#fd20,0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#122,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#1005,.s0
	dw #385,#1005,.s0
	dw #384,#f00,#cd,#0,#2005,.s0
	dw #385,#3005,.s0
	dw #300,#f00,#146,#1b,#1000,#1a,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#102,#0,#35,#fd00,#2002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#2002,.s1
	dw #385,0
	dw #304,#f00,#f4,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#0,#36,#fd00,0
	dw #385,0
	dw #380,#f00,#a3,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#0,#36,#fd00,0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#0,#36,#fd00,0
	dw #385,0
	dw #380,#f00,#a3,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#0,#36,#fd00,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#f4,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#cd,#0,#36,#fd00,0
	dw #385,0
	dw #384,#f00,#a3,#0,0
	dw #385,0
	dw #304,#f00,#146,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#0,#36,#fd00,0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#f4,#1b,#1000,#0,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3005,.s0
	dw #385,0
	dw #384,#f00,#a3,#1b,#3005,.s0
	dw #385,0
	dw #304,#f00,#146,#1b,#0,#fd00,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#159,#0,#35,#fd0e,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#2002,.s1
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#1b,#0,#0,#fd0e,#4005,.s0
	dw #381,#1000,#0,#0,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd0e,#3002,.s1
	dw #385,#1002,.s1
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #381,#1000,#0,#1b,0
	dw #300,#f00,#146,#1b,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #381,#1000,#0,#0,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#159,#0,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#1b,#0,#0,#fd0e,#4005,.s0
	dw #381,#1000,#0,#0,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #381,#1000,#0,#1b,0
	dw #300,#f00,#146,#1b,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #304,#f00,#159,#0,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#38,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #304,#f00,#159,#0,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd0e,#2002,.s1
	dw #385,0
	dw #384,#f00,#d9,#1b,#3005,.s0
	dw #385,0
	dw #300,#f00,#102,#1b,#1000,#1a,#1b,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#35,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#f4,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1b,#3005,.s0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#2002,.s1
	dw #385,#2002,.s1
	dw #384,#f00,#d9,#0,#3005,.s0
	dw #385,0
	dw #300,#f00,#122,#1b,#1000,#1a,#1b,#0,#fd00,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#35,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#122,#1b,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,#3002,.s1
	dw #381,#1000,#0,#1b,0
	dw #304,#f00,#122,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,#2002,.s1
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,#1002,.s1
	dw #385,0
	dw #304,#f00,#146,#0,#38,#fd20,#3002,.s1
	dw #385,0
	dw #384,#f00,#cd,#0,#2002,.s1
	dw #385,0
	dw #304,#f00,#122,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #384,#f00,#cd,#0,#2002,.s1
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,#3002,.s1
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#1005,.s0
	dw #385,#1005,.s0
	dw #384,#f00,#cd,#0,#2005,.s0
	dw #385,#3005,.s0
	dw #300,#f00,#146,#1b,#1000,#1a,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#102,#0,#35,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#f4,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#a3,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#a3,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#f4,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#cd,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#a3,#0,0
	dw #385,0
	dw #304,#f00,#146,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#0,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#f4,#1b,#1000,#0,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3005,.s0
	dw #385,0
	dw #384,#f00,#a3,#1b,#3005,.s0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#0,#a3,#a3,#fd00,#4005,.s0
	dw #381,#1000,#0,#a3,0
	dw #380,#f00,#d9,#1b,#1000,#1b,#1b,0
	dw #384,#f00,#d9,#0,0
	dw #300,#f00,#159,#1b,#1000,#a3,#1b,#35,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#1b,#2002,.s1
	dw #384,#f00,#d9,#0,0
	dw #300,#f00,#146,#1b,#1000,#1b,#0,#0,#fd0e,#4005,.s0
	dw #381,#1000,#a3,#0,0
	dw #380,#f00,#d9,#1b,#1000,#1b,#1b,0
	dw #384,#f00,#d9,#0,0
	dw #304,#f00,#122,#1b,#36,#fd0e,#3002,.s1
	dw #385,#1002,.s1
	dw #380,#f00,#d9,#1b,#1000,#1b,#81,0
	dw #380,#f00,#d9,#0,#1000,#0,#81,0
	dw #300,#f00,#146,#1b,#1000,#0,#6c,#6c,#fd0e,#4005,.s0
	dw #381,#1000,#0,#6c,0
	dw #380,#f00,#d9,#1b,#1000,#1b,#1b,0
	dw #384,#f00,#d9,#0,0
	dw #300,#f00,#159,#1b,#1000,#6c,#1b,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#1b,0
	dw #384,#f00,#d9,#0,0
	dw #300,#f00,#146,#1b,#1000,#1b,#0,#0,#fd0e,#4005,.s0
	dw #381,#1000,#0,#0,0
	dw #380,#f00,#d9,#1b,#1000,#1b,#1b,0
	dw #384,#f00,#d9,#0,0
	dw #304,#f00,#122,#1b,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#1b,#1000,#1b,#1b,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #300,#f00,#146,#0,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #304,#f00,#159,#0,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#0,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#38,#fd0e,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#56,#1b,0
	dw #381,#1000,#81,#1b,0
	dw #300,#f00,#146,#0,#1000,#0,#1b,#ac,#fd0e,#4005,.s0
	dw #381,#1000,#0,#ac,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #300,#f00,#159,#0,#1000,#ac,#1b,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#0,#1000,#ac,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#ac,#1b,0
	dw #385,0
	dw #300,#f00,#122,#0,#1000,#0,#1b,#36,#fd0e,#2002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,#3005,.s0
	dw #385,0
	dw #300,#f00,#102,#1a,#1000,#1a,#a3,#a3,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #300,#f00,#122,#1b,#1000,#a3,#1b,#35,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#a3,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#f4,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,#3005,.s0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#2002,.s1
	dw #385,#2002,.s1
	dw #384,#f00,#d9,#0,#3005,.s0
	dw #385,0
	dw #300,#f00,#122,#1b,#1000,#1a,#1b,#91,#fd20,#4005,.s0
	dw #381,#1000,#0,#91,0
	dw #380,#f00,#cd,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#35,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#a3,#3002,.s1
	dw #385,0
	dw #300,#f00,#122,#1b,#1000,#1b,#1b,#ac,#fd0c,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#159,#1b,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#1b,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#1b,#1b,#3002,.s1
	dw #381,#1000,#0,#1b,0
	dw #304,#f00,#122,#1b,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,#2002,.s1
	dw #304,#f00,#122,#1b,#1b,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,#1002,.s1
	dw #385,0
	dw #304,#f00,#146,#0,#38,#fd20,#3002,.s1
	dw #385,0
	dw #384,#f00,#cd,#0,#2002,.s1
	dw #385,0
	dw #304,#f00,#122,#1b,#1b,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#3002,.s1
	dw #385,0
	dw #384,#f00,#cd,#0,#2002,.s1
	dw #385,0
	dw #300,#f00,#159,#1b,#1000,#a3,#1b,#146,#fd0c,#4005,.s0
	dw #385,0
	dw #300,#f00,#cd,#0,#1000,#ac,#1b,#159,#fd0c,#3002,.s1
	dw #385,0
	dw #304,#f00,#146,#0,#36,#fd20,#1005,.s0
	dw #385,#1005,.s0
	dw #384,#f00,#cd,#0,#2005,.s0
	dw #385,#3005,.s0
	dw #300,#f00,#146,#1a,#1000,#1a,#1b,#a3,#fd20,#4005,.s0
	dw #381,#1000,#1a,#a3,0
	dw #380,#f00,#d9,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#35,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#f4,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#a3,#0,#1000,#1b,#81,0
	dw #385,0
	dw #300,#f00,#146,#1a,#1000,#1b,#1b,#6c,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#a3,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#f4,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#a3,#0,0
	dw #385,0
	dw #304,#f00,#146,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#f4,#1a,#1000,#0,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3005,.s0
	dw #385,0
	dw #384,#f00,#a3,#0,#3005,.s0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#0,#a3,#a3,#fd00,#4005,.s0
	dw #381,#1000,#0,#a3,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #300,#f00,#159,#0,#1000,#a3,#1b,#35,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,#2002,.s1
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#1b,#0,#0,#fd0e,#4005,.s0
	dw #381,#1000,#0,#0,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd0e,#3002,.s1
	dw #385,#1002,.s1
	dw #380,#f00,#d9,#0,#1000,#1b,#91,0
	dw #381,#1000,#0,#91,0
	dw #300,#f00,#146,#1b,#1000,#0,#a3,#a3,#fd0e,#4005,.s0
	dw #381,#1000,#0,#a3,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #300,#f00,#159,#0,#1000,#a3,#1b,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#1b,#0,#0,#fd0e,#4005,.s0
	dw #381,#1000,#0,#0,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #381,#1000,#0,#1b,0
	dw #300,#f00,#146,#1b,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #304,#f00,#159,#0,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#0,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #304,#f00,#122,#0,#38,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#146,#1b,#ac,#fd0e,#4005,.s0
	dw #381,#1000,#0,#ac,0
	dw #380,#f00,#d9,#0,#1000,#0,#1b,0
	dw #385,0
	dw #300,#f00,#159,#0,#1000,#ac,#1b,#36,#fd0e,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #300,#f00,#146,#1b,#1000,#ac,#0,#0,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#ac,#1b,0
	dw #385,0
	dw #300,#f00,#122,#0,#1000,#0,#1b,#36,#fd0e,#2002,.s1
	dw #381,#1000,#b7,#1b,0
	dw #380,#f00,#d9,#0,#1000,#c1,#1b,#3005,.s0
	dw #381,#1000,#cd,#1b,0
	dw #300,#f00,#102,#1a,#1000,#1a,#d9,#d9,#fd0e,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#122,#1b,#35,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#d9,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#0,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#f4,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#0,0
	dw #385,0
	dw #304,#f00,#102,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#0,#3005,.s0
	dw #385,0
	dw #304,#f00,#122,#1b,#36,#fd00,#2002,.s1
	dw #385,#2002,.s1
	dw #384,#f00,#d9,#0,#3005,.s0
	dw #385,0
	dw #300,#f00,#122,#17,#1000,#17,#1b,#91,#fd00,#4005,.s0
	dw #381,#1000,#0,#91,0
	dw #380,#f00,#cd,#0,#1000,#17,#18,0
	dw #385,0
	dw #304,#f00,#146,#0,#2f,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#18,#18,#3002,.s1
	dw #385,0
	dw #304,#f00,#159,#18,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#18,0
	dw #380,#f00,#cd,#0,#1000,#18,#18,0
	dw #385,0
	dw #304,#f00,#146,#0,#30,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#18,#a3,#3002,.s1
	dw #385,0
	dw #300,#f00,#122,#18,#1000,#18,#18,#ac,#fd0c,#4005,.s0
	dw #381,#1000,#0,#18,0
	dw #380,#f00,#cd,#0,#1000,#18,#18,0
	dw #385,0
	dw #304,#f00,#146,#0,#30,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#18,#18,0
	dw #385,0
	dw #304,#f00,#159,#18,#0,#fd20,#4005,.s0
	dw #381,#1000,#0,#18,0
	dw #380,#f00,#cd,#0,#1000,#18,#18,0
	dw #385,0
	dw #304,#f00,#146,#0,#30,#fd20,#3002,.s1
	dw #385,0
	dw #380,#f00,#cd,#0,#1000,#18,#18,#3002,.s1
	dw #381,#1000,#0,#18,0
	dw #304,#f00,#122,#18,#0,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,0
	dw #304,#f00,#146,#0,#30,#fd20,#3002,.s1
	dw #385,0
	dw #384,#f00,#cd,#0,0
	dw #385,#2002,.s1
	dw #304,#f00,#0,#18,#18,#fd20,#4005,.s0
	dw #385,0
	dw #384,#f00,#159,#0,#1002,.s1
	dw #384,#f00,#159,#0,0
	dw #304,#f00,#cd,#146,#38,#fd20,#3002,.s1
	dw #384,#f00,#cd,#0,0
	dw #384,#f00,#146,#cd,#2002,.s1
	dw #384,#f00,#146,#0,0
	dw #304,#f00,#cd,#122,#18,#fd20,#4005,.s0
	dw #384,#f00,#cd,#0,0
	dw #384,#f00,#122,#cd,0
	dw #384,#f00,#122,#0,0
	dw #304,#f00,#cd,#146,#36,#fd20,#3002,.s1
	dw #384,#f00,#cd,#0,0
	dw #384,#f00,#146,#cd,#2002,.s1
	dw #384,#f00,#146,#0,0
	dw #300,#f00,#cd,#159,#1000,#a3,#18,#146,#fd0c,#4005,.s0
	dw #384,#f00,#cd,#0,0
	dw #300,#f00,#159,#cd,#1000,#ac,#18,#159,#fd0c,#3002,.s1
	dw #384,#f00,#159,#0,0
	dw #304,#f00,#cd,#146,#36,#fd20,#1005,.s0
	dw #384,#f00,#cd,#0,#1005,.s0
	dw #384,#f00,#146,#cd,#2005,.s0
	dw #384,#f00,#146,#0,#3005,.s0
	dw #300,#f00,#146,#1a,#1000,#1a,#1b,#a3,#fd20,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#1a,#1000,#1a,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#35,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#1b,#1000,#1b,#1b,#3002,.s1
	dw #385,0
	dw #304,#f00,#f4,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#1a,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#a3,#1b,#1000,#1b,#81,0
	dw #385,0
	dw #300,#f00,#146,#1a,#1000,#1b,#1b,#6c,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#1a,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#102,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#d9,#1b,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #380,#f00,#d9,#1a,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #380,#f00,#a3,#1b,#1000,#1b,#1b,0
	dw #385,0
	dw #304,#f00,#146,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1a,0
	dw #385,0
	dw #304,#f00,#102,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#1b,0
	dw #385,0
	dw #304,#f00,#f4,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1a,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#a3,#1b,0
	dw #385,0
	dw #304,#f00,#146,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1a,0
	dw #385,0
	dw #304,#f00,#102,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#1b,0
	dw #385,0
	dw #300,#f00,#f4,#1a,#1000,#0,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1a,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3005,.s0
	dw #385,0
	dw #384,#f00,#a3,#1b,#3005,.s0
	dw #385,0
	dw #304,#f00,#146,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1a,0
	dw #385,0
	dw #304,#f00,#102,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#1b,0
	dw #385,0
	dw #300,#f00,#f4,#1a,#1000,#0,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1a,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3005,.s0
	dw #385,0
	dw #384,#f00,#a3,#1b,#3005,.s0
	dw #385,0
	dw #304,#f00,#146,#1a,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1a,0
	dw #385,0
	dw #304,#f00,#102,#1b,#36,#fd00,#3002,.s1
	dw #385,0
	dw #384,#f00,#d9,#1b,0
	dw #385,0
	dw #300,#f00,#f4,#1a,#1000,#0,#1b,#0,#fd00,#4005,.s0
	dw #385,0
	dw #384,#f00,#d9,#1a,0
	dw #385,0
	dw #304,#f00,#cd,#1b,#36,#fd00,#3005,.s0
	dw #385,0
	dw #384,#f00,#a3,#1b,#3005,.s0
	dw #385,0
	dw #385,#1005,.s0
	dw #385,#1005,.s0
	dw #385,#1005,.s0
	dw #385,#1005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#4005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#3005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#2005,.s0
	dw #385,#1005,.s0
	dw #385,#1005,.s0
	dw #385,#1005,.s0
	dw #381,#1000,#0,#0,#1005,.s0
	dw #700,#f00,#0,#6c,#1000,#0,#0,#36,#fd0c,#3008,.s0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#d9,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#d9,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#ac,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#ac,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#66,0
	dw #784,#f00,#0,#7a,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#66,#0,0
	dw #784,#f00,#7a,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#0,#66,0
	dw #784,#f00,#0,#7a,0
	dw #784,#f00,#0,#ac,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#66,#0,0
	dw #784,#f00,#7a,#0,0
	dw #784,#f00,#ac,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#91,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#91,#0,0
	dw #784,#f00,#a3,#0,0
	dw #784,#f00,#0,#6c,0
	dw #784,#f00,#0,#81,0
	dw #784,#f00,#0,#ac,0
	dw #784,#f00,#0,#a3,0
	dw #784,#f00,#6c,#0,0
	dw #784,#f00,#81,#0,0
	dw #784,#f00,#ac,#0,0
	dw #784,#f00,#a3,#0,0
	dw #884,#f00,#0,#6c,0
	dw #884,#f00,#0,#81,0
	dw #884,#f00,#0,#91,0
	dw #884,#f00,#0,#d9,0
	dw #884,#f00,#6c,#0,0
	dw #884,#f00,#81,#0,0
	dw #884,#f00,#91,#0,0
	dw #884,#f00,#d9,#0,0
	dw #884,#f00,#0,#6c,0
	dw #884,#f00,#0,#81,0
	dw #884,#f00,#0,#91,0
	dw #884,#f00,#0,#a3,0
	dw #884,#f00,#6c,#0,0
	dw #884,#f00,#81,#0,0
	dw #884,#f00,#91,#0,0
	dw #884,#f00,#a3,#0,0
	dw #884,#f00,#0,#6c,0
	dw #884,#f00,#0,#81,0
	dw #884,#f00,#0,#91,0
	dw #884,#f00,#0,#ac,0
	dw #884,#f00,#6c,#0,0
	dw #884,#f00,#81,#0,0
	dw #884,#f00,#91,#0,0
	dw #884,#f00,#ac,#0,0
	dw #884,#f00,#0,#6c,0
	dw #884,#f00,#0,#81,0
	dw #884,#f00,#0,#91,0
	dw #884,#f00,#0,#a3,0
	dw #884,#f00,#6c,#0,0
	dw #884,#f00,#81,#0,0
	dw #884,#f00,#91,#0,0
	dw #884,#f00,#a3,#0,0
	dw #984,#f00,#0,#66,0
	dw #984,#f00,#0,#7a,0
	dw #984,#f00,#0,#a3,0
	dw #984,#f00,#0,#cd,0
	dw #984,#f00,#66,#0,0
	dw #984,#f00,#7a,#0,0
	dw #984,#f00,#a3,#0,0
	dw #984,#f00,#cd,#0,0
	dw #984,#f00,#0,#66,0
	dw #984,#f00,#0,#7a,0
	dw #984,#f00,#0,#ac,0
	dw #984,#f00,#0,#f4,0
	dw #984,#f00,#66,#0,0
	dw #984,#f00,#7a,#0,0
	dw #984,#f00,#ac,#0,0
	dw #984,#f00,#f4,#0,0
	dw #a84,#f00,#0,#d9,0
	dw #a84,#f00,#0,#a3,0
	dw #a84,#f00,#0,#81,0
	dw #a84,#f00,#0,#6c,0
	dw #a84,#f00,#d9,#0,0
	dw #a84,#f00,#a3,#0,0
	dw #a84,#f00,#81,#0,0
	dw #a84,#f00,#6c,#0,0
	dw #a84,#f00,#0,#6c,0
	dw #a84,#f00,#0,#81,0
	dw #a84,#f00,#0,#a3,0
	dw #a84,#f00,#0,#d9,0
	dw #a84,#f00,#6c,#0,0
	dw #a84,#f00,#81,#0,0
	dw #a84,#f00,#a3,#0,0
	dw #a84,#f00,#d9,#0,0
	dw #a84,#f00,#6c,#0,0
	dw #a84,#f00,#81,#0,0
	dw #a84,#f00,#a3,#0,0
	dw #a84,#f00,#d9,#0,0
	db #40
.s0:
	db #26,#3c,#4b,#3a,#4b,#40,#55,#47,#66,#4f,#71,#5c,#82,#6b,#97,#7c
	db #a8,#90,#be,#a4,#d8,#bf,#f7,#d0,#0,#f,#c3,#0,#42,#ae
.s1:
	db #3,#10,#38,#4c,#56,#4b,#5a,#2,#1,#41,#71,#3c,#5c,#44,#2,#2
	db #5f,#3,#14,#4,#4,#34,#3,#2
