/*
 * Decompiled with CFR 0.152.
 */
package org.kd.common;

import java.util.HashMap;
import java.util.Map;
import org.kd.common.Scene;

public class SceneManager {
    private final Map<String, Scene> scenes = new HashMap<String, Scene>();
    private Scene currentScene;

    public void addScene(String name, Scene scene) {
        this.scenes.put(name, scene);
    }

    public void switchScene(String name) {
        if (this.currentScene != null) {
            this.currentScene.dispose();
        }
        this.currentScene = this.scenes.values().stream().filter(s -> s.id.equals(name)).findFirst().get();
        this.currentScene.create();
    }

    public void update(float delta) {
        if (this.currentScene != null) {
            this.currentScene.update(delta);
        }
    }

    public void render() {
        if (this.currentScene != null) {
            this.currentScene.render();
        }
    }

    public void disposeScenes() {
        this.scenes.values().forEach(scene -> scene.dispose());
    }
}

