/*
 * Decompiled with CFR 0.152.
 */
package org.kd.winter25;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.kd.common.BasicC64Screen;
import org.kd.common.C64Colors;
import org.kd.common.C64Helper;
import org.kd.common.Globals;
import org.kd.common.winter.WinterEffects;
import org.lwjgl.util.Point;

public class Scene1c64
extends BasicC64Screen {
    public SpriteBatch batch2;
    BitmapFont fontSmall;
    private List<Sprite> backgroundSprites;
    private List<Sprite> backgroundSprites2;
    private List<Sprite> snowflakes;
    private List<Point> snowPatches;
    private List<Sprite> letters;
    private float snowPatchThreshold = 90.0f;
    private Sprite backgroundSprite3;
    private Sprite christmasTree;
    private Sprite christmasCaption;
    private Sprite santa;
    private Sprite reset;
    private ShapeRenderer shapeRenderer;
    private boolean snowing;

    public Scene1c64(String id) {
        super(id);
    }

    @Override
    public void create() {
        super.create();
        this.snowing = true;
        this.batch2 = new SpriteBatch(2);
        this.fontSmall = C64Helper.createFont(12, "C64_Pro_Mono-STYLE.ttf");
        this.fontSmall.setColor(Color.BLACK);
        this.backgroundSprites = new ArrayList<Sprite>(2);
        this.backgroundSprites2 = new ArrayList<Sprite>(2);
        this.snowPatches = new ArrayList<Point>();
        this.snowflakes = new ArrayList<Sprite>();
        this.letters = new ArrayList<Sprite>(5);
        AtomicReference<Float> shift = new AtomicReference<Float>(Float.valueOf(0.0f));
        Arrays.asList("lda1.png", "sta$d020.png").forEach(picPath -> this.initSprite((String)picPath, shift, this.backgroundSprites));
        Arrays.asList("poke646_1.png", "clrscr.png").forEach(picPath -> this.initSprite((String)picPath, shift, this.backgroundSprites2));
        AtomicReference<Float> shift2 = new AtomicReference<Float>(Float.valueOf(0.0f));
        Arrays.asList("m.png", "e.png", "r.png", "r.png", "y.png").forEach(picPath -> {
            this.initSprite((String)picPath, new AtomicReference<Float>(Float.valueOf(0.0f)), this.letters);
            Sprite letter = this.letters.get(this.letters.size() - 1);
            letter.setX(100.0f * (((Float)shift2.get()).floatValue() + 1.0f));
            letter.setY(380.0f);
            letter.setScale(0.2f, 0.2f);
            shift2.set(Float.valueOf(((Float)shift2.get()).floatValue() + 1.0f));
        });
        this.backgroundSprite3 = new Sprite(new Texture("winter/lightblu_bkgnd.png"));
        this.backgroundSprite3.setX(0.0f);
        this.backgroundSprite3.setY(250.0f);
        this.snowflakes = WinterEffects.createSnowflakeSprites();
        this.christmasTree = new Sprite(new Texture("winter/choinka.png"));
        this.christmasTree.setScale(1.0f, 0.0f);
        this.christmasTree.setPosition(486.0f, 120.0f);
        this.christmasCaption = new Sprite(new Texture("winter/Christmas.png"));
        this.christmasCaption.setScale(0.25f, 1.0f);
        this.christmasCaption.setPosition(0.0f, 361.0f);
        this.reset = new Sprite(new Texture("winter/reset.png"));
        this.reset.setScale(0.1f, 0.1f);
        this.reset.setPosition(400.0f, 300.0f);
        this.santa = new Sprite(new Texture("winter/santa.png"));
        this.santa.setScale(1.0f, 1.0f);
        this.santa.setPosition(150.0f, 30.0f);
        this.shapeRenderer = new ShapeRenderer();
    }

    private void initSprite(String picPath, AtomicReference<Float> shift, List<Sprite> spriteList) {
        Texture texture = new Texture("winter/" + picPath);
        Sprite sprite = new Sprite(texture);
        sprite.setX(200.0f + shift.get().floatValue());
        sprite.setY(320.0f + shift.get().floatValue());
        shift.set(Float.valueOf(shift.get().floatValue() - 30.0f));
        spriteList.add(sprite);
    }

    @Override
    public void update(float delta) {
        long frame = Gdx.graphics.getFrameId();
        if (frame == 400L) {
            this.borderColor = C64Colors.WHITE;
        } else if (frame == 600L) {
            Globals.CURSOR_COLOR = C64Colors.WHITE;
        } else if (frame == 699L) {
            this.backgroundScreenPng = "winter/white-ready.png";
            this.backgroundTexture = new Texture(Gdx.files.internal(this.backgroundScreenPng));
            Globals.cursorY = Math.round(451.8) - 2L;
        } else if (frame == 1100L) {
            this.backgroundScreenPng = "lblue-ready.png";
            this.backgroundTexture = new Texture(Gdx.files.internal(this.backgroundScreenPng));
            Globals.BKG_COLOR = C64Colors.LIGHT_BLUE;
        }
        if (this.snowing) {
            for (int startIndex = 0; startIndex <= 6; ++startIndex) {
                if (frame <= (long)(1100 + startIndex * 100)) continue;
                WinterEffects.snow(startIndex, this.snowflakes);
            }
        }
        if (frame > 1499L && frame % 3L == 0L) {
            this.createSnowPatch();
        }
        if (frame > 2730L && frame % 2L == 0L) {
            long index = frame % 5L;
            Sprite letter = this.letters.get((int)index);
            float scale = letter.getScaleX();
            if (scale < 1.1f) {
                scale += 0.05f;
            }
            letter.setScale(scale, scale);
        }
        if (frame > 3255L) {
            Sprite cc = this.christmasCaption;
            if (cc.getScaleX() < 1.0f) {
                cc.setScale(cc.getScaleX() + 0.1f);
            }
            if (cc.getX() < 200.0f) {
                cc.setX(cc.getX() + 1.0f);
            }
        }
        if (frame > 3400L && frame % 2L == 0L && this.letters.get(0).getY() > 360.0f) {
            this.letters.get(0).setY(this.letters.get(0).getY() - 1.0f);
            this.letters.get(4).setY(this.letters.get(4).getY() - 1.0f);
        }
        if (frame > 3530L && frame % 4L == 0L && this.christmasTree.getScaleY() < 0.95f) {
            this.christmasTree.setScale(1.0f, this.christmasTree.getScaleY() + 0.05f);
        }
        if (frame > 8600L && frame < 8800L) {
            this.reset.setScale(this.reset.getScaleX() + 0.02f);
        }
    }

    private void createSnowPatch() {
        if (this.snowPatchThreshold < 138.0f) {
            this.snowPatchThreshold += 0.15f;
        }
        int min = 50;
        int max = 750;
        int x = (int)(new Random().nextDouble() * (double)(max - min) + (double)min);
        int y = Math.round(this.snowPatchThreshold);
        Point p = new Point(x, y);
        this.snowPatches.add(p);
        if (x < min + max / 2) {
            this.snowPatches.add(new Point(x + 2, y + 1));
        }
    }

    @Override
    public void render() {
        super.render();
        long frame = Gdx.graphics.getFrameId();
        this.batch2.begin();
        if (frame > 300L && frame < 700L) {
            List<Sprite> spriteGroup = this.backgroundSprites;
            if (frame > 550L) {
                spriteGroup = this.backgroundSprites2;
            }
            this.flySprites(spriteGroup);
        }
        if (frame > 900L) {
            float x = this.backgroundSprite3.getX();
            this.backgroundSprite3.setX(x + 1.5f);
            double y = (double)this.backgroundSprite3.getY() + 3.5 * Math.sin((double)x / (Math.PI * 4));
            this.backgroundSprite3.setY((float)y);
            this.backgroundSprite3.draw(this.batch2);
        }
        for (int startIndex = 0; startIndex <= 6; ++startIndex) {
            if (frame <= (long)(1100 + startIndex * 100)) continue;
            for (int i = startIndex; i < this.snowflakes.size(); i += 7) {
                this.snowflakes.get(i).draw(this.batch2);
            }
        }
        if (frame > 1234L) {
            this.snowPatches.forEach(point -> this.whiteFont.draw((Batch)this.batch2, "#", (float)point.getX(), (float)point.getY()));
            this.christmasTree.draw(this.batch2);
        }
        if (frame > 2730L) {
            this.letters.forEach(letter -> letter.draw(this.batch2));
        }
        if (frame > 3255L) {
            this.christmasCaption.draw(this.batch2);
        }
        if (frame > 3800L && frame < 8500L) {
            this.santa.draw(this.batch2);
        }
        this.drawWishes(this.batch2, this.fontSmall, frame, 4000, 4800, Arrays.asList("KD and K&A+", " team send", "best wishes", "2 all retro", "maniacs !!!", "   YOU", "  ROCK !!!"));
        this.drawWishes(this.batch2, this.fontSmall, frame, 4850, 5650, Arrays.asList(" Let this", " festive", "  season", " bring you", "lotsa joy !", " Joy and", "joysticks !"));
        this.drawWishes(this.batch2, this.fontSmall, frame, 5700, 6600, Arrays.asList("  Spend", " Christmas", " with your", "family, but", "also don't", "forget abt", "your retro", "hardware."));
        this.drawWishes(this.batch2, this.fontSmall, frame, 6650, 7450, Arrays.asList("Once supper", " is over,", "take your", " siblings, ", " turn on", "  INTER.", "KARATE and"));
        this.drawWishes(this.batch2, this.fontSmall, frame, 7500, 8300, Arrays.asList("   KICK", "  THEIR", " BUTTS !!!", "  HA HA !", "  HO! HO!", "  Merry", "Christmas !"));
        if (frame > 8600L && frame < 9150L) {
            this.reset.draw(this.batch2);
        }
        if (frame > 8700L) {
            this.executeReset();
        }
        this.batch2.end();
    }

    private void executeReset() {
        this.snowing = false;
        Globals.CURSOR_COLOR = C64Colors.LIGHT_BLUE;
        this.shapeRenderer.setColor(Color.WHITE);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        int width = 90;
        this.shapeRenderer.rect(0.0f, 0.0f, width, 600.0f);
        this.shapeRenderer.rect(800 - width, 0.0f, width, 600.0f);
        this.shapeRenderer.end();
    }

    private void drawWishes(SpriteBatch batch, BitmapFont font, long currentFrame, int startFrame, int endFrame, List<String> wishes) {
        if (currentFrame > (long)startFrame && currentFrame < (long)endFrame) {
            for (int i = 0; i < wishes.size(); ++i) {
                font.draw((Batch)batch, wishes.get(i), 338.0f, (float)(235 - 23 * i));
            }
        }
    }

    private void flySprites(List<Sprite> spriteGroup) {
        for (int i = 0; i < spriteGroup.size(); ++i) {
            Sprite s = spriteGroup.get(i);
            this.flyCaptionSprite(s, i);
        }
    }

    private void flyCaptionSprite(Sprite s, int i) {
        s.draw(this.batch2);
        s.setX(s.getX() + (float)(i + 1));
        s.setY(s.getY() - (float)(i - 1));
        s.setScale(s.getScaleX() + 0.01f, s.getScaleY() + 0.01f);
        s.setAlpha(1.0f);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.batch2.dispose();
        for (Sprite sprite : this.backgroundSprites) {
            sprite.getTexture().dispose();
        }
    }
}

