;Revoke

;By Harekiet for Evoke 2025


PIXELS equ 4000
;FRAMES equ ( 62 * 1024 - 512 ) / 64
FRAMES equ 1024
FRAMESHIGH equ FRAMES / 256
FRAMESTART equ ( 1 * 1024 + 128 ) * 1024
RAND_RANGE equ 32
RAND_HALF equ 15

cpu 386
org	0100h

;save initial registers
pusha

;Setup video mode
mov	al,13h
int	10h

;Write some text
mov dh, 22

dec bx ;color 0xff
drawFont:

mov dl, dh
shl dl, 3

mov cl, 7
mov ax, 0x1300
mov bp, text
int 10h

dec dh
jnz drawFont

;Restore so bx is 0 again
popa

;set video segment
push 0xa000
pop es

xor si, si
mov di, pixels

;Find all the valid pixel and generate particles
initLoop:

inc byte [es:si]
jnz skipCreate

mov ax, si
mov bp, 320
xor dx, dx
div bp

pusha

;x coordinate
fild word [bx-8]
fstp dword [di]

;y coordinate
fild word [bx-4]
fstp dword [di+4]

popa

;center pixels
sub ax, 100
sub dx, 160

pusha

;Get the center dx/dy for an angle
;x
fild word [bx-8]
;y coordinate
fild word [bx-4]

;distance y x
fld st0
fmul st0
;y2 y x
fld st2
;x y2 y x
fmul st0
;x2 y2 y x
faddp
fsqrt
;len y x
;fidiv word [CONST_100]
;ffiv dword [0x123]
;fidiv word [0x12a]
fdiv st0

fxch st2
; x y len
fpatan
; angle len
fsincos
; dx dy len
fmul st2
fstp dword [di+12]
;dy len
fmulp st1
fstp dword [di+8]

popa

;next particle
add di, 16

skipCreate:

;clear the screen so there's no blur issues
mov [es:si],bl

inc si
jnz initLoop

moreframes:

;Frame generation loop
;mov dx, FRAMES
mov dh, FRAMESHIGH

frameLoop:

mov cx, PIXELS
mov di, pixels

particleLoop:

pusha

;forward the pixels and store them in ax and si
fld dword [di]
fist word [bx-4]	;save ax
fadd dword [di+8]
fstp dword [di]

fld dword [di+4]
fist word [bx-16]	;save si
fadd dword [di+12]
fstp dword [di+4]
 
popa

add di, 16

imul si, bp
add si, ax
inc byte [esi+FRAMESTART]
framecounter equ $-2
loop particleLoop

add word [framecounter],1

;Generate frames
dec dx
jnz frameLoop

;Get back the framecount

;mov cx, FRAMES
mov ch, FRAMESHIGH

;Enable the speaker
;mov     al, 00000011b  
dec ax
out     61h, al

displayloop:

;do some sound at least
mov     al, 0xa6		;timer 2, mode 3, hi byte only
out     43h, al         ; a new countdown value
;add al, cl
mov al, cl
mul ch
;add al, ch
out 42h, al


;vsync thing
mov dx,0x3da
sync_test:
in al,dx
test al,8
jz sync_test

displaypixelloop:

mov al,[es:si]
cmp [esi+FRAMESTART+FRAMES*64*1024],bl

displaycounter equ $-2

je skipplot
mov al, 31
morecolors equ $-2
;mov al, cl
;add al, 0
skipplot:
and al, 31
dec al
jns skipReplace
and al, 0
skipReplace:
;or al,al
je skipadd
add al, 32
skipadd:
mov byte [es:si], al

;add byte [es:si], al


inc si
jnz displaypixelloop

sub word [displaycounter],1

disabledecrease equ $-1

loop displayloop

;modify some code for final bit
mov byte [disabledecrease],0
;turn into a mov al,cl
mov word [morecolors], 0xc888
jmp displayloop


text:
db 'EVOKE!'

;here the particles get stored
pixels:


