	PLOT = $E50C	; Kernal routine moves cursor to (y,x)
	ROW = $d6	; Cursor row
	COL = $d3	; Cursor column
	PNT = $d1	; Pointer to start of current line
	TAPE1 = $b2	; Pointer to tape buffer @ $33c

	*=$33e		; Load pattern and code into tape buffer
pattern
;	.byte $00	;%00000000
	.byte $02	;%00000010
	.byte $51	;%01010001
	.byte $30	;%00110000
	.byte $72	;%01110010
	.byte $09	;%00001001
	.byte $04	;%00000100
	.byte $92	;%10010010
	.byte $49	;%01001001
;	.byte $ff	;%11111111

-	bcs draw	; if bit is set, draw the star
check	sre (TAPE1),y	; then grab a bit from pattern
	dex		; move up 1 row per bit
	bne -		; if rows remain, keep pulling bits and drawing 
start
	ldx #10		; always start on middle row
	iny		; move to next column, but for each column first
draw			; draw a star and its rotations
	jsr PLOT	; update PNT to row X
	lda #'*'	; A = 42
	sta (PNT),y	; plot * at Y,X
	lsr		; A = 21, C = 0
	sbc ROW		; A = 21 - ROW + (C-1) = 20-ROW
	tay		; Y = 20-ROW
	ldx COL		; X = COL    => 90º clockwise rotation around (10,10)
	inc $2		; unused zp, defaults to 0
	bne draw	; repeat 256 times
	beq check	; move on to next bit
