;---------------------------------.
; CHUNK BUFFER RENDERING ROUTINES |-.
; (c) 1998 by Flying/DR           | |
;_________________________________; |
  ;_________________________________;

;THIS ROUTINES ARE USES #8000-#8FFF MEMORY AREA

;-------------------------------------.
;IM 2 HANDLER MUST HAVE THE FOLLOWING |-.
;STRUCTURE:                           | |
;IM2      _IM2_START                  | |
;         <All what you want>         | |
;         _IM2_END                    | |
;_____________________________________| |
  ;_____________________________________|

SCRBUF  EQU #6000                       ;CHUNK BUFFER
OUTDATA EQU SCRBUF+(BUF_XS*BUF_YS)      ;BUF_YS*4*4

.IF USE_CLEAR
CLEAR_TABLE EQU OUTDATA+(BUF_YS*4*4)    ;BUF_YS*2
.ENDIF

MOVE_TABLE_1 EQU #8010  ;!!! THESE ADDRESSES
MOVE_TABLE_2 EQU #8410  ;!!! CAN'T BE CHANGED
MOVE_TABLE_3 EQU #8810  ;!!! COZ THEY ARE USED
MOVE_TABLE_4 EQU #8C10  ;!!! IN CREATE_MOVE_TABLE ROUTINE

IM2_SP    DEFW 0
IM2_RET   DEFW 0        ;RET POINTER FOR IM2 ROUTINE

IS_CLEAR  DEFB 0        ;WHEN THIS VARIABLE IS <>0 THEN
                        ;IT MEANS, THAT SCRBUF CLEARING IS
                        ;PROCESSING NOW!

OUTPUT_INIT
;...INSTALL OUTPUT ROUTINE...
        LD HL,_OUT0
        LD DE,_EOUT0
        LD BC,0+((BUF_XS/2)-1)*(_EOUT0-_OUT0)
        LDIR
;...CREATE MOVE_TABLE_x ROUTINES
        LD HL,MOVE_TABLE_1
        CALL CREATE_MOVE_TABLE
        LD HL,MOVE_TABLE_2
        CALL CREATE_MOVE_TABLE
        LD HL,MOVE_TABLE_3
        CALL CREATE_MOVE_TABLE
        LD HL,MOVE_TABLE_4
        CALL CREATE_MOVE_TABLE
        LD HL,SCRBUF
        LD DE,SCRADR
        LD BC,BUF_XS
        CALL CREATE_OUTDATA
        LD HL,FAST_OUT_1
        LD (FAST_OUTPUT+1),HL
        RET

CREATE_OUTDATA
        ;THIS PROCEDURE CREATE OUTDATA TABLE WITH POINTERS
        ;ON EACH LINE INTO INPUT AND OUTPUT BUFFERS
        ;AT ENTER:
        ;  HL - POINTER ON SOURCE BUFFER
        ;  DE - POINTER ON DESTINATION BUFFER (USUALLY SCREEN)
        ;  BC - SIZE OF ONE LINE OF SOURCE BUFFER
        ;       THIS IS NEED TO DO OUTPUT POLYGONES, WHERE
        ;       IS REAL LINE SIZE BIGGER THEN BUF_XS
        LD (CROD_11+1),HL
        LD (CROD_12+1),HL
        LD (CROD_13+1),HL
        LD (CROD_14+1),HL
.IF USE_CLEAR
        LD (CROD_CLR1+1),HL
.ENDIF
        LD (CROD_21+1),DE
        INC D
        LD (CROD_22+1),DE
        INC D
        LD (CROD_23+1),DE
        INC D
        LD (CROD_24+1),DE
        LD (CROD_3+1),BC
.IF USE_CLEAR
        LD (CROD_CLR2+1),BC
.ENDIF
        LD IX,OUTDATA
CROD_11 LD HL,00000
CROD_21 LD DE,00000
        CALL CROD_0
CROD_12 LD HL,00000
CROD_22 LD DE,00000
        CALL CROD_0
CROD_13 LD HL,00000
CROD_23 LD DE,00000
        CALL CROD_0
CROD_14 LD HL,00000
CROD_24 LD DE,00000
        CALL CROD_0
        LD HL,OUTDATA
        LD (OUTDATA_PTR+1),HL
.IF USE_CLEAR
CROD_CLR1
        LD HL,00000
CROD_CLR2
        LD DE,00000
        CALL CREATE_CLEAR
.ENDIF
        RET
CROD_0  LD B,BUF_YS
CROD_1  PUSH BC
        LD (IX+0),E
        LD (IX+1),D
        LD (IX+2),L
        LD (IX+3),H
        CALL NLINDE
        CALL NLINDE
        CALL NLINDE
        CALL NLINDE
CROD_3  LD BC,00000
        ADD HL,BC
        LD BC,4
        ADD IX,BC
        POP BC
        DJNZ CROD_1
        RET

CREATE_MOVE_TABLE
        ;AT ENTER:
        ;   HL - PTR ON MOVE_TABLE_x ROUTINE
        XOR A
        LD (CRMVT_3+1),A
        LD (CRMVT_4+1),HL
        LD A,H
        RRCA
        RRCA
        AND 3
        LD (GTB_1+1),A  ;NUMBER OF CHUNK'S LINE
        LD HL,#8000
        LD (CRMVT_5+1),HL
        LD B,4
CRMVT_1 PUSH BC
        LD B,#20
CRMVT_2 PUSH BC
CRMVT_3 LD A,00
        CALL GET_TABLE_BYTE
        LD E,A
        LD A,(CRMVT_3+1)
        INC A
        CALL GET_TABLE_BYTE
        LD D,A
        LD A,(CRMVT_3+1)
        INC A
        INC A
        LD (CRMVT_3+1),A
CRMVT_4 LD HL,00000
        LD (HL),#21             ;LD HL,nnnnn
        INC HL
        LD (HL),E
        INC HL
        LD (HL),D
        INC HL
        LD (HL),#22             ;LD (nnnnn),HL
        INC HL
CRMVT_5 LD DE,00000
        LD (HL),E
        INC HL
        LD (HL),D
        INC HL
        LD (CRMVT_4+1),HL
        INC DE
        INC DE
        LD C,E          ;THIS PART OF ROUTINE IS MOVING
        LD A,E          ;POINTER INT ORESULT TABLE ON NEXT
        AND #0F         ;ADDRESS.
        LD E,A          ;COZ THIS TABLE IS PLACED IN 
        LD A,C          ;ADDRESSES #8x00-#8x0F, THEN I CAN
        RRCA            ;DO JUST AND #0F TO CUT HIGH BITS
        RRCA            ;AND USE HIGH BIT TO GO TO NEXT
        RRCA            ;PART OF TABLE (#8000->#8100)
        RRCA            ;
        AND #01         ;
        ADD A,D         ;
        LD D,A          ;
        LD (CRMVT_5+1),DE
        POP BC
        DJNZ CRMVT_2
        LD HL,(CRMVT_4+1)
        LD (CRMVT_6+1),HL
        LD (HL),#C3             ;JP nnnnn
        INC HL
        LD (HL),#10             ;IT'S COZ THIS ROUTINE
        INC HL                  ;ALWAYS CONTINUES AT #8x10
        LD A,H
        INC A
        LD D,A
        LD E,#10
        LD (HL),A
        LD (CRMVT_4+1),DE
        POP BC
        DJNZ CRMVT_1
CRMVT_6 LD HL,00000
        LD (HL),#C9             ;RET
        RET

GET_TABLE_BYTE
        ;RETURNED IN A BYTE, WHICH MUST BE STORED IN 
        ;TABLE.
        ;AT ENTER:
        ;   A - BYTE'S INDEX IN TABLE
        PUSH HL
        PUSH DE
        PUSH BC
GTB_1   LD HL,00000             ;MOVE POINTER TO NEEDED LINE
        LD DE,TEXTURES          ;OF CHUNK'S TEXTURE
        ADD HL,DE
        EX DE,HL
        LD B,A
        AND #0F
        ADD A,A
        ADD A,A
        LD L,A
        LD H,0
        ADD HL,DE
        PUSH HL
        LD A,B
        RRCA                    ;A=(A/16)*4
        RRCA
        AND #3C
        LD L,A
        LD H,0
        ADD HL,DE
        POP DE
        LD A,(DE)
        AND #F0
        LD C,A
        LD A,(HL)
        AND #0F
        OR C
        POP BC
        POP DE
        POP HL
        RET

FAST_OUTPUT
        JP 00000

FAST_OUT_1
        LD HL,OUTDATA
        LD (OUTDATA_PTR+1),HL
        CALL MOVE_TABLE_1
        CALL OUTPUT_LINE
        LD HL,FAST_OUT_2
        LD (FAST_OUTPUT+1),HL
        RET

FAST_OUT_2
        CALL MOVE_TABLE_2
        CALL OUTPUT_LINE
        LD HL,FAST_OUT_3
        LD (FAST_OUTPUT+1),HL
        RET

FAST_OUT_3
        CALL MOVE_TABLE_3
        CALL OUTPUT_LINE
        LD HL,FAST_OUT_4
        LD (FAST_OUTPUT+1),HL
        RET

FAST_OUT_4
        CALL MOVE_TABLE_4
        CALL OUTPUT_LINE
        LD HL,FAST_OUT_1
        LD (FAST_OUTPUT+1),HL
        RET

OUTPUT  LD HL,OUTDATA
        LD (OUTDATA_PTR+1),HL
        CALL MOVE_TABLE_1
        CALL OUTPUT_LINE
        CALL MOVE_TABLE_2
        CALL OUTPUT_LINE
        CALL MOVE_TABLE_3
        CALL OUTPUT_LINE
        CALL MOVE_TABLE_4
        CALL OUTPUT_LINE
        RET

OUTPUT_LINE
        LD (OUT_SAVESP+1),SP
        LD A,BUF_YS
OUTLN_1 EX AF,AF'
OUTDATA_PTR
        LD HL,00000
        LD E,(HL)
        INC HL
        LD D,(HL)
        INC HL
        LD C,(HL)
        INC HL
        LD B,(HL)
        INC HL
        LD (OUTDATA_PTR+1),HL
        LD H,B
        LD L,C
        LD (OUT_SP+1),HL
        LD C,(HL)
        INC HL
        LD B,(HL)
        LD H,B
        LD L,C
;
;WE'RE NEED THESE TWO LINES MARKED WITH ~DON'T REMOVE~, COZ
;IT CAN BE A SITUATION WHERE INTERRUPT IS CAME IMMEDIATELY IN 
;THIS PLACES.
;IN 1-ST PLACE IT MAY CAUSE A SITUATION WHEN SP=#A0ED, SO IM2
;CHECKER WILL BE FAILED AND CAUSE A DATA LOSE
;IN 2-ND PLACE WE'RE HAVE AN LDI EXECUTED, BUT DON'T HAVE A
;~PUSH HL~ IN NEXT BYTE, SO IM2 CHECK WILL BE FAILED
;
_START_OUTPUT
OUT_SP  LD SP,00000
        NOP             ;DON'T REMOVE!!!!!
 _OUT0  POP HL
        SET 7,H
        LDI
_EOUT0  DEFS ((BUF_XS/2)-1)*(_EOUT0-_OUT0),0
        POP HL          ;DON'T REMOVE!!!!!!
OUT_SAVESP
        LD SP,00000
_END_OUTPUT
        EX AF,AF'
        DEC A
        JP NZ,OUTLN_1
        RET

.IF USE_CLEAR
CREATE_CLEAR
        ;AT ENTER:
        ;  HL - POINTER ON SOURCE BUFFER
        ;  DE - SIZE OF ONE LINE OF SOURCE BUFFER
        ;       THIS IS NEED TO DO OUTPUT POLYGONES, WHERE
        ;       IS REAL LINE SIZE BIGGER THEN BUF_XS
        LD (CRCLR2+1),DE
        LD DE,BUF_XS
        ADD HL,DE
        EX DE,HL
        LD HL,CLEAR_TABLE
        LD B,BUF_YS
CRCLR1  LD (HL),E
        INC HL
        LD (HL),D
        INC HL
        PUSH HL
CRCLR2  LD HL,00000
        ADD HL,DE
        EX DE,HL
        POP HL
        DJNZ CRCLR1
        RET

CLEAR   LD (CLEAR_SP+1),SP
        LD HL,CLEAR_TABLE
        LD E,(HL)       ;THIS IS NEED TO CORRECT WORK OF
        INC HL          ;ROUTINE. IT'S COZ THERE CAN BE A CAUSE
        LD D,(HL)       ;THAT INTERRUPT IS CAME WHEN IS_CLEAR=1
        DEC HL          ;BUT SP IS NOT IN SCREEN BUFFER. SO, IF
        EX DE,HL        ;THESE LINES IS NOT PRESENT IT WILL
        LD A,1          ;CAUSE 2 BYTES LOSING!
        LD (IS_CLEAR),A ;
        LD SP,HL        ;
        EX DE,HL        ;
        LD B,BUF_YS
CLEAR_1 LD E,(HL)
        INC HL
        LD D,(HL)
        INC HL
        EX DE,HL
        LD SP,HL
        EX DE,HL
        LD DE,0
        DEFS BUF_XS/2,#D5       ;PUSH DE
        DJNZ CLEAR_1
CLEAR_SP
        LD SP,00000
        XOR A
        LD (IS_CLEAR),A
        RET
.ENDIF

TEXTURES
.IF CHUNK_TYPE-CHUNK_DITHER
        DEFB #00,#00,#00,#00
        DEFB #88,#00,#00,#00
        DEFB #88,#00,#22,#00
        DEFB #AA,#00,#22,#00
        DEFB #AA,#00,#AA,#00
        DEFB #AA,#44,#AA,#00
        DEFB #AA,#44,#AA,#11
        DEFB #AA,#55,#AA,#11
        DEFB #AA,#55,#AA,#55
        DEFB #EE,#55,#AA,#55
        DEFB #EE,#55,#BB,#55
        DEFB #FF,#55,#BB,#55
        DEFB #FF,#55,#FF,#55
        DEFB #FF,#DD,#FF,#55
        DEFB #FF,#DD,#FF,#77
        DEFB #FF,#FF,#FF,#FF
.ENDIF
.IF CHUNK_TYPE-CHUNK_PIXEL
        DEFB #00,#00,#00,#00
        DEFB #00,#66,#00,#00
        DEFB #00,#66,#44,#00
        DEFB #00,#66,#66,#00
        DEFB #00,#66,#77,#00
        DEFB #00,#77,#77,#00
        DEFB #11,#77,#77,#00
        DEFB #33,#77,#77,#00
        DEFB #77,#77,#77,#00
        DEFB #FF,#77,#77,#00
        DEFB #FF,#FF,#77,#00
        DEFB #FF,#FF,#FF,#00
        DEFB #FF,#FF,#FF,#88
        DEFB #FF,#FF,#FF,#CC
        DEFB #FF,#FF,#FF,#EE
        DEFB #FF,#FF,#FF,#FF
.ENDIF

        DEFMAC _IM2_START
        LD (IM2_SP),SP
        LD SP,IM2_STACK
        PUSH IX
        PUSH HL
        PUSH DE
        PUSH BC
        PUSH AF
        EX AF,AF'
        PUSH AF
        EX AF,AF'
        EXX
        PUSH HL
        PUSH DE
        PUSH BC
        EXX
        PUSH HL
        LD HL,(IM2_SP)
        LD E,(HL)               ;SAVE EXIT POINT
        INC HL
        LD D,(HL)
        LD (IM2_RET),DE
        POP BC
        LD HL,_START_OUTPUT
        OR A
        SBC HL,DE
        JR NC,...0
        LD HL,_END_OUTPUT
        OR A
        SBC HL,DE
        JR C,...0
        LD H,B
        LD L,C
        RES 7,H
        DEC DE
        LD A,(DE)
        CP #A0      ;IF A=#A0 THEN IT MEANS THAT ~LDI~ (#ED #A0)
                    ;WAS THE LAST EXECUTED COMMAND AND WE'RE
                    ;MUST CORRECT HL
        JR NZ,...2
        INC DE
        LD A,(DE)
        CP #E1      ;CHECK IF CORRENT COMMAND IS ~POP HL~ (#E1)
        JR NZ,...2
        DEC HL
...2    EX DE,HL
        LD HL,(IM2_SP)
        LD (HL),E               ;RESTORE WORD
        INC HL
        LD (HL),D
.IF USE_CLEAR
...0    LD A,(IS_CLEAR)
        OR A
        JR Z,...1
        LD HL,(IM2_SP)
        LD (HL),0               ;CLEAR CURRENT WORD
        INC HL
        LD (HL),0
...1
.ELSE
...0
.ENDIF
        ENDMAC

        DEFMAC _IM2_END
        LD HL,(IM2_RET)
        LD (...0+1),HL
        POP BC
        POP DE
        POP HL
        EXX
        POP AF
        EX AF,AF'
        POP AF
        POP BC
        POP DE
        POP HL
        POP IX
        LD SP,(IM2_SP)
        INC SP
        INC SP
        EI
...0    JP 00000
        ENDMAC

                                                         